/*
 * Decompiled with CFR 0.152.
 */
package dev.themeinerlp.plugindebug;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.themeinerlp.plugindebug.DebugFile;
import dev.themeinerlp.plugindebug.FileType;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Ldev/themeinerlp/plugindebug/DebugFileAdapter;", "Lcom/google/gson/TypeAdapter;", "Ldev/themeinerlp/plugindebug/DebugFile;", "<init>", "()V", "read", "in", "Lcom/google/gson/stream/JsonReader;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "plugin-debug"})
public final class DebugFileAdapter
extends TypeAdapter<DebugFile> {
    public void write(@NotNull JsonWriter out, @NotNull DebugFile value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        out.beginObject().name("filePath").value(PathsKt.getName((Path)value.getFilePath())).name("fileType").value(value.getFileType().name()).name("uiTabName").value(value.getUiTabName()).endObject();
    }

    @NotNull
    public DebugFile read(@NotNull JsonReader in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        in.beginObject();
        String filePath = in.nextString();
        String string = in.nextString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"read");
        FileType fileType = FileType.valueOf(string);
        String uiTabName = in.nextString();
        in.endObject();
        Path path = Paths.get(filePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"read");
        Intrinsics.checkNotNullExpressionValue((Object)uiTabName, (String)"read");
        return new DebugFile(path, fileType, uiTabName);
    }
}

