/*
 * Decompiled with CFR 0.152.
 */
package dev.vanengine.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeBinaryResolver {
    private static final Logger log = LoggerFactory.getLogger(NativeBinaryResolver.class);
    private static final String VERSION = NativeBinaryResolver.loadVersion();
    private static final String RELEASE_VERSION = VERSION.replaceFirst("-SNAPSHOT$", "");
    private static final String GITHUB_RELEASE_BASE = "https://github.com/vanengine/van/releases/download/v" + RELEASE_VERSION + "/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadVersion() {
        try (InputStream in = NativeBinaryResolver.class.getResourceAsStream("/van-core.properties");){
            if (in == null) return "0.1.16";
            Properties props = new Properties();
            props.load(in);
            String string = props.getProperty("van.compiler.version", "0.1.16");
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "0.1.16";
    }

    public Path resolve() {
        String envPath = System.getenv("VAN_COMPILER_PATH");
        if (envPath != null && !envPath.isBlank()) {
            Path p = Path.of(envPath, new String[0]);
            if (Files.isExecutable(p)) {
                log.info("Using van-compiler from VAN_COMPILER_PATH: {}", (Object)p);
                return p;
            }
            throw new IllegalStateException("VAN_COMPILER_PATH is set to " + envPath + " but file is not executable or does not exist");
        }
        String suffix = NativeBinaryResolver.platformSuffix();
        Path cached = Path.of(System.getProperty("user.home"), ".van", "bin", "van-compiler-wasi-" + VERSION + suffix);
        if (Files.isExecutable(cached)) {
            log.debug("Using cached van-compiler: {}", (Object)cached);
            return cached;
        }
        Path onPath = this.findOnPath();
        if (onPath != null) {
            log.info("Using van-compiler from PATH: {}", (Object)onPath);
            return onPath;
        }
        String artifactName = NativeBinaryResolver.artifactName();
        String url = GITHUB_RELEASE_BASE + artifactName;
        log.info("Downloading van-compiler {} for {} from {}", new Object[]{VERSION, NativeBinaryResolver.platformDescription(), url});
        this.download(url, cached);
        log.info("van-compiler cached at {}", (Object)cached);
        return cached;
    }

    private Path findOnPath() {
        String pathEnv = System.getenv("PATH");
        if (pathEnv == null) {
            return null;
        }
        boolean windows = NativeBinaryResolver.isWindows();
        String binaryName = windows ? "van-compiler-wasi.exe" : "van-compiler-wasi";
        for (String dir : pathEnv.split(System.getProperty("path.separator"))) {
            Path candidate = Path.of(dir, binaryName);
            if (!Files.isExecutable(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private void download(String url, Path target) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                throw new IOException("HTTP " + response.statusCode() + " downloading " + url);
            }
            try (InputStream in = response.body();){
                Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!NativeBinaryResolver.isWindows()) {
                target.toFile().setExecutable(true);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Failed to download van-compiler from " + url, e);
        }
    }

    private static String detectOs() {
        String os = System.getProperty("os.name", "").toLowerCase();
        if (os.contains("linux")) {
            return "linux";
        }
        if (os.contains("mac") || os.contains("darwin")) {
            return "darwin";
        }
        if (os.contains("win")) {
            return "windows";
        }
        throw new UnsupportedOperationException("Unsupported OS: " + os);
    }

    private static String detectArch() {
        String arch = System.getProperty("os.arch", "").toLowerCase();
        if (arch.equals("amd64") || arch.equals("x86_64")) {
            return "x64";
        }
        if (arch.equals("aarch64") || arch.equals("arm64")) {
            return "arm64";
        }
        throw new UnsupportedOperationException("Unsupported architecture: " + arch);
    }

    private static boolean isWindows() {
        return "windows".equals(NativeBinaryResolver.detectOs());
    }

    private static String platformSuffix() {
        return NativeBinaryResolver.isWindows() ? ".exe" : "";
    }

    private static String artifactName() {
        String os = NativeBinaryResolver.detectOs();
        String arch = NativeBinaryResolver.detectArch();
        String name = "van-compiler-" + os + "-" + arch;
        if (NativeBinaryResolver.isWindows()) {
            name = name + ".exe";
        }
        return name;
    }

    private static String platformDescription() {
        return NativeBinaryResolver.detectOs() + "-" + NativeBinaryResolver.detectArch();
    }
}

