/*
 * Decompiled with CFR 0.152.
 */
package dev.vanengine.core;

import dev.vanengine.core.VanCompiler;
import dev.vanengine.core.VanTemplate;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public class VanEngine {
    private final VanCompiler compiler;
    private Path basePath;

    public VanEngine(VanCompiler compiler) {
        this.compiler = compiler;
    }

    public void setBasePath(Path basePath) {
        this.basePath = basePath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VanTemplate getTemplate(String templatePath) throws IOException {
        Path vanFile = this.basePath.resolve(templatePath);
        String html = this.compiler.compile(vanFile, this.basePath).html();
        return new VanTemplate(html);
    }

    public VanTemplate getTemplate(String entryPath, Map<String, String> files) throws IOException {
        String html = this.compiler.compile(entryPath, files).html();
        return new VanTemplate(html);
    }

    public VanTemplate getLiteralTemplate(String templateContent) throws IOException {
        String html = this.compiler.compile("literal.van", Map.of("literal.van", templateContent)).html();
        return new VanTemplate(html);
    }

    public String compile(String templatePath, Map<String, ?> model) throws IOException {
        return this.getTemplate(templatePath).evaluate(model);
    }

    public String compileLiteral(String templateContent, Map<String, ?> model) throws IOException {
        return this.getLiteralTemplate(templateContent).evaluate(model);
    }

    public static class Builder {
        private Path basePath;

        private Builder() {
        }

        public Builder basePath(Path basePath) {
            this.basePath = basePath;
            return this;
        }

        public VanEngine build() {
            try {
                VanCompiler compiler = new VanCompiler();
                compiler.init();
                VanEngine engine = new VanEngine(compiler);
                if (this.basePath != null) {
                    engine.setBasePath(this.basePath);
                }
                return engine;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize VanCompiler", e);
            }
        }
    }
}

