/*
 * Decompiled with CFR 0.152.
 */
package dev.vanengine.core;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VanTemplate {
    private static final Pattern MUSTACHE = Pattern.compile("\\{\\{\\s*(.+?)\\s*}}");
    private final String compiledHtml;

    VanTemplate(String compiledHtml) {
        this.compiledHtml = compiledHtml;
    }

    public String evaluate(Map<String, ?> model) {
        Matcher matcher = MUSTACHE.matcher(this.compiledHtml);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String expr = matcher.group(1);
            Object value = this.resolve(expr, model);
            if (value != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(this.escapeHtml(value.toString())));
                continue;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group(0)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String getHtml() {
        return this.compiledHtml;
    }

    private Object resolve(String expr, Map<String, ?> model) {
        String[] parts = expr.split("\\.");
        Object current = model.get(parts[0]);
        for (int i = 1; i < parts.length && current != null; ++i) {
            if (!(current instanceof Map)) {
                return null;
            }
            Map map = (Map)current;
            current = map.get(parts[i]);
        }
        return current;
    }

    private String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }
}

