/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.CheckBox;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.DefaultWindowManager;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.MultiWindowTextGUI;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.RadioBoxList;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowManager;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.TerminalScreen;
import com.googlecode.lanterna.screen.VirtualScreen;
import com.googlecode.lanterna.terminal.DefaultTerminalFactory;
import com.googlecode.lanterna.terminal.Terminal;
import fi.evolver.script.Shell;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.UUID;

public class Dialog {
    private static final String SEPARATOR = UUID.randomUUID().toString();
    private static final LayoutData LANTERNA_LAYOUT_SPAN_END = GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.END, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)true, (boolean)false, (int)2, (int)1);
    private static final LayoutData LANTERNA_LAYOUT_SPAN_BEGINNING = GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.BEGINNING, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)true, (boolean)false, (int)2, (int)1);
    public static UiMode DEFAULT_UI_MODE = UiMode.LANTERNA;
    private final List<DialogEntry> entries = new ArrayList<DialogEntry>();
    private final String title;
    private UiMode uiMode;

    public Dialog(String title) {
        this.title = title;
        this.uiMode = DEFAULT_UI_MODE;
    }

    public Dialog add(DialogEntry entry) {
        this.entries.add(entry);
        return this;
    }

    public Dialog setUiMode(UiMode mode) {
        this.uiMode = mode;
        return this;
    }

    public SequencedMap<DialogEntry, String> show() {
        if (this.entries.isEmpty()) {
            return Collections.emptySortedMap();
        }
        UiMode effectiveMode = this.determineEffectiveUiMode();
        return switch (effectiveMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.showZenityDialog();
            case 1 -> this.showLanternaDialog();
        };
    }

    private UiMode determineEffectiveUiMode() {
        if (this.uiMode == UiMode.LANTERNA) {
            return UiMode.LANTERNA;
        }
        try {
            Process process = new ProcessBuilder("which", "zenity").start();
            int exitCode = process.waitFor();
            boolean hasZenity = exitCode == 0;
            return hasZenity ? UiMode.ZENITY : UiMode.LANTERNA;
        }
        catch (IOException | InterruptedException e) {
            return UiMode.LANTERNA;
        }
    }

    private SequencedMap<DialogEntry, String> showZenityDialog() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/zenity");
        command.add("--forms");
        command.add("--ok-label");
        command.add("Submit");
        command.add("--title");
        command.add(this.title);
        command.add("--text");
        command.add(this.title);
        command.add("--separator");
        command.add(SEPARATOR);
        block6: for (DialogEntry entry : this.entries) {
            DialogEntry dialogEntry;
            Objects.requireNonNull(entry);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DialogParagraph.class, DialogTextField.class, DialogCheckBox.class, DialogRadioSelect.class}, (Object)dialogEntry, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DialogParagraph paragraph = (DialogParagraph)dialogEntry;
                    command.add("--add-entry");
                    command.add(paragraph.label());
                    command.add("--add-entry");
                    command.add("");
                    continue block6;
                }
                case 1: {
                    boolean isMultiline;
                    DialogTextField textField = (DialogTextField)dialogEntry;
                    boolean bl = isMultiline = textField.rows() > 1;
                    if (isMultiline) {
                        System.err.println("Warning: Zenity has limited support for multiline fields. Consider using Lanterna UI mode instead.");
                    }
                    command.add(textField.isPassword() ? "--add-password" : "--add-entry");
                    command.add(textField.label());
                    continue block6;
                }
                case 2: {
                    DialogCheckBox checkBox = (DialogCheckBox)dialogEntry;
                    System.err.println("Warning: Zenity forms don't support native checkboxes. Using text field instead.");
                    command.add("--add-entry");
                    command.add(checkBox.label() + " (Enter 'true' or 'false')");
                    continue block6;
                }
                case 3: 
            }
            DialogRadioSelect radioButton = (DialogRadioSelect)dialogEntry;
            System.err.println("Warning: Zenity forms don't support native radio buttons. Using text field instead.");
            StringBuilder optionsText = new StringBuilder(radioButton.label()).append(" (Enter one of: ");
            List<String> options = radioButton.options();
            for (int i = 0; i < options.size(); ++i) {
                if (i > 0) {
                    optionsText.append(", ");
                }
                optionsText.append("'").append(options.get(i)).append("'");
            }
            optionsText.append(")");
            command.add("--add-entry");
            command.add(optionsText.toString());
        }
        String output = Shell.user(command);
        String[] values = output.split(SEPARATOR);
        LinkedHashMap<DialogEntry, String> results = new LinkedHashMap<DialogEntry, String>();
        int valueIndex = 0;
        for (DialogEntry entry : this.entries) {
            if (valueIndex >= values.length) continue;
            results.put(entry, values[valueIndex].replaceFirst("\n$", ""));
            ++valueIndex;
        }
        return results;
    }

    private SequencedMap<DialogEntry, String> showLanternaDialog() {
        try {
            DefaultTerminalFactory terminalFactory = new DefaultTerminalFactory();
            Terminal terminal = terminalFactory.createTerminal();
            TerminalScreen screen = new TerminalScreen(terminal);
            screen.doResizeIfNecessary();
            screen.startScreen();
            BasicWindow window = new BasicWindow(this.title);
            window.setHints(List.of(Window.Hint.MODAL));
            Panel contentPanel = new Panel();
            contentPanel.setLayoutManager((LayoutManager)new GridLayout(2).setHorizontalSpacing(1).setVerticalSpacing(1));
            Map<DialogEntry, Component> fieldComponents = this.createLanternaComponents();
            fieldComponents.forEach((entry, component) -> {
                if (entry instanceof DialogParagraph) {
                    Label paragraphLabel = (Label)component;
                    paragraphLabel.setLayoutData(LANTERNA_LAYOUT_SPAN_BEGINNING);
                    contentPanel.addComponent((Component)paragraphLabel);
                } else {
                    contentPanel.addComponent((Component)new Label(entry.label()));
                    contentPanel.addComponent((Component)fieldComponents.get(entry));
                }
            });
            Button submitButton = new Button("Submit", () -> ((BasicWindow)window).close());
            Panel buttonPanel = new Panel((LayoutManager)new GridLayout(2));
            buttonPanel.addComponent((Component)new EmptySpace(new TerminalSize(0, 0)));
            buttonPanel.addComponent((Component)submitButton);
            buttonPanel.setLayoutData(LANTERNA_LAYOUT_SPAN_END);
            contentPanel.addComponent((Component)buttonPanel);
            Panel mainPanel = new Panel();
            mainPanel.setLayoutManager((LayoutManager)new LinearLayout(Direction.VERTICAL));
            mainPanel.addComponent((Component)contentPanel);
            window.setComponent((Component)mainPanel);
            VirtualScreen virtualScreen = new VirtualScreen((Screen)screen);
            MultiWindowTextGUI gui = new MultiWindowTextGUI((Screen)virtualScreen, (WindowManager)new DefaultWindowManager(), (Component)new EmptySpace());
            gui.addWindowAndWait((Window)window);
            LinkedHashMap<DialogEntry, String> results = new LinkedHashMap<DialogEntry, String>();
            block8: for (DialogEntry entry2 : this.entries) {
                Component component2;
                Component component3 = fieldComponents.get(entry2);
                Objects.requireNonNull(component3);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextBox.class, CheckBox.class, RadioBoxList.class, Label.class}, (Object)component2, n)) {
                    case 0: {
                        TextBox textBox = (TextBox)component2;
                        results.put(entry2, textBox.getText());
                        continue block8;
                    }
                    case 1: {
                        CheckBox checkBox = (CheckBox)component2;
                        results.put(entry2, Boolean.toString(checkBox.isChecked()));
                        continue block8;
                    }
                    case 2: {
                        RadioBoxList radioBoxList = (RadioBoxList)component2;
                        int selectedIndex = radioBoxList.getSelectedIndex();
                        List<String> options = ((DialogRadioSelect)entry2).options();
                        results.put(entry2, selectedIndex >= 0 && selectedIndex < options.size() ? options.get(selectedIndex) : "");
                        continue block8;
                    }
                    case 3: {
                        Label ignored = (Label)component2;
                        results.put(entry2, "");
                        continue block8;
                    }
                }
                throw new IllegalStateException("not supported component type: " + String.valueOf(component3.getClass()));
            }
            screen.stopScreen();
            terminal.close();
            return results;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to show Lanterna dialog", e);
        }
    }

    private Map<DialogEntry, Component> createLanternaComponents() {
        LinkedHashMap<DialogEntry, Component> fieldComponents = new LinkedHashMap<DialogEntry, Component>();
        block6: for (DialogEntry entry : this.entries) {
            DialogEntry dialogEntry;
            Objects.requireNonNull(entry);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DialogParagraph.class, DialogTextField.class, DialogCheckBox.class, DialogRadioSelect.class}, (Object)dialogEntry, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DialogParagraph paragraph = (DialogParagraph)dialogEntry;
                    Label label = new Label(paragraph.label().strip());
                    fieldComponents.put(entry, (Component)label);
                    continue block6;
                }
                case 1: {
                    DialogTextField textField = (DialogTextField)dialogEntry;
                    TextBox textBox = new TextBox(new TerminalSize(textField.columns(), textField.rows()));
                    if (textField.isPassword()) {
                        textBox.setMask(Character.valueOf('*'));
                    }
                    textBox.setText(textField.defaultValue());
                    fieldComponents.put(entry, (Component)textBox);
                    continue block6;
                }
                case 2: {
                    DialogCheckBox checkBox = (DialogCheckBox)dialogEntry;
                    CheckBox checkComponent = new CheckBox("");
                    checkComponent.setChecked(checkBox.defaultValue());
                    fieldComponents.put(entry, (Component)checkComponent);
                    continue block6;
                }
                case 3: 
            }
            DialogRadioSelect radioButton = (DialogRadioSelect)dialogEntry;
            RadioBoxList radioBoxList = new RadioBoxList();
            radioButton.options().forEach(arg_0 -> ((RadioBoxList)radioBoxList).addItem(arg_0));
            radioBoxList.setCheckedItemIndex(radioButton.defaultSelectedIndex());
            fieldComponents.put(entry, (Component)radioBoxList);
        }
        return fieldComponents;
    }

    public static void showMessage(String title, String message) {
        Dialog dialog = new Dialog(title);
        dialog.add(new DialogParagraph(message));
        dialog.show();
    }

    public static String readLine(String prompt) {
        return Dialog.readUserInput(prompt, Dialog.textField(""), null);
    }

    public static String readMultilineText(String prompt) {
        return Dialog.readUserInput(prompt, Dialog.textArea(""), null);
    }

    public static String readPassword(String prompt) {
        return Dialog.readUserInput(prompt, Dialog.passwordField(""), null);
    }

    public static String readMultilinePassword(String prompt) {
        return Dialog.readUserInput(prompt, Dialog.passwordArea(""), null);
    }

    public static String readLine(String prompt, UiMode mode) {
        return Dialog.readUserInput(prompt, Dialog.textField(""), mode);
    }

    public static String readPassword(String prompt, UiMode mode) {
        return Dialog.readUserInput(prompt, Dialog.passwordField(""), mode);
    }

    public static String readMultilinePassword(String prompt, UiMode mode) {
        return Dialog.readUserInput(prompt, Dialog.passwordArea(""), mode);
    }

    private static String readUserInput(String prompt, DialogEntry entry, UiMode mode) {
        Dialog dialog = new Dialog(prompt);
        dialog.add(entry);
        if (mode != null) {
            dialog.setUiMode(mode);
        }
        SequencedMap<DialogEntry, String> result = dialog.show();
        return (String)result.get(entry);
    }

    public static DialogTextField textField(String label) {
        return new DialogTextField(label, "", 1, 50, false);
    }

    public static DialogTextField passwordField(String label) {
        return new DialogTextField(label, "", 1, 50, true);
    }

    public static DialogTextField textArea(String label) {
        return new DialogTextField(label, "", 15, 72, false);
    }

    public static DialogTextField passwordArea(String label) {
        return new DialogTextField(label, "", 15, 72, true);
    }

    public static DialogCheckBox checkBox(String label, boolean defaultValue) {
        return new DialogCheckBox(label, defaultValue);
    }

    public static DialogRadioSelect radioSelect(String label, List<String> options) {
        return new DialogRadioSelect(label, options);
    }

    public static DialogRadioSelect radioSelect(String label, List<String> options, int defaultSelectedIndex) {
        return new DialogRadioSelect(label, options, defaultSelectedIndex);
    }

    public static DialogParagraph paragraph(String text) {
        return new DialogParagraph(text);
    }

    public static enum UiMode {
        ZENITY,
        LANTERNA;

    }

    public static sealed interface DialogEntry
    permits DialogCheckBox, DialogParagraph, DialogRadioSelect, DialogTextField {
        public String label();
    }

    public record DialogParagraph(String label) implements DialogEntry
    {
    }

    public record DialogTextField(String label, String defaultValue, int rows, int columns, boolean isPassword) implements DialogEntry
    {
    }

    public record DialogCheckBox(String label, boolean defaultValue) implements DialogEntry
    {
    }

    public record DialogRadioSelect(String label, List<String> options, int defaultSelectedIndex) implements DialogEntry
    {
        public DialogRadioSelect {
            if (options.isEmpty()) {
                throw new IllegalArgumentException("Options list cannot be empty");
            }
            if (defaultSelectedIndex < 0 || defaultSelectedIndex >= options.size()) {
                throw new IllegalArgumentException("Default selected index is out of bounds");
            }
        }

        public DialogRadioSelect(String label, List<String> options) {
            this(label, options, 0);
        }
    }
}

