/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.FileUtil;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;

public class Ssh {
    public static final Path SSH_DIR = Shell.HOME.resolve(".ssh");

    public static void ensureHostIsKnown(String host) {
        try (Step step = Step.start("Ensure %s is in known_hosts".formatted(host));){
            if (!Ssh.isKnownHost(host)) {
                Ssh.addKnownHost(host);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isKnownHost(String host) {
        return Shell.Command.user("ssh-keygen", "-F", host).failOnError(false).run().success();
    }

    private static void addKnownHost(String host) throws IOException {
        Files.createDirectories(SSH_DIR, new FileAttribute[0]);
        String keyInfo = Shell.user("ssh-keyscan", "-H", host);
        FileUtil.append(SSH_DIR.resolve("known_hosts"), keyInfo);
    }

    public static Path storePrivateKey(String keyName, String privateKey) throws IOException {
        try (Step step = Step.start("Store private key %s".formatted(keyName));){
            if (privateKey == null || privateKey.isBlank()) {
                step.fail("Private key is empty");
            }
            if (keyName == null || keyName.isBlank()) {
                step.fail("Key name is empty");
            }
            Files.createDirectories(SSH_DIR, new FileAttribute[0]);
            Path keyPath = SSH_DIR.resolve(keyName);
            FileUtil.write(keyPath, privateKey, EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
            Path path = keyPath;
            return path;
        }
    }

    public static Path storePublicKey(String keyName, String publicKey) throws IOException {
        try (Step step = Step.start("Add public key %s".formatted(keyName));){
            if (keyName == null || keyName.isBlank()) {
                step.fail("Key name is empty");
            }
            if (publicKey == null || publicKey.isBlank()) {
                step.fail("Public key is empty");
            }
            Files.createDirectories(SSH_DIR, new FileAttribute[0]);
            Path keyPath = SSH_DIR.resolve(keyName);
            FileUtil.write(keyPath, publicKey);
            Path path = keyPath;
            return path;
        }
    }
}

