package fi.evolver.script.app;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;

import fi.evolver.script.Download;
import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;

public class SublimeText {

	private static final String SUBLIME_KEYRING_NAME = "sublimehq-archive.gpg";
	private static final Path CONF_DIR = Shell.HOME.resolve(".config/sublime-text");
	private static final Gson GSON = new Gson();

	public static void install() {
		try (Step step = Step.start("Sublime Text: Install")) {
			Apt.addPublicKey(SUBLIME_KEYRING_NAME, URI.create("https://download.sublimetext.com/sublimehq-pub.gpg"));
			Apt.addSource("sublime-text", "deb [signed-by=/etc/apt/keyrings/%s] https://download.sublimetext.com/ apt/stable/"
					.formatted(SUBLIME_KEYRING_NAME)
			);
			Apt.update();
			Apt.install("sublime-text");
		}
	}

	public static void installPackageControl() throws IOException {
		try (Step step = Step.start("Sublime Text: Install Package Control")) {
			Path targetFile = CONF_DIR
					.resolve("Installed Packages")
					.resolve("Package Control.sublime-package");

			if (Files.exists(targetFile)) {
				step.skip("Package Control already installed");
				return;
			}

			Files.createDirectories(targetFile.getParent());

			Download.intoFile(
					URI.create("https://packagecontrol.io/Package%20Control.sublime-package"),
					targetFile
			);
		}
	}

	public static void setPackagesToInstall(List<String> packageNames) throws IOException {
		try (Step step = Step.start("Sublime Text: Set packages to install")) {
			Path settingsFile = CONF_DIR
					.resolve("Packages")
					.resolve("User")
					.resolve("Package Control.sublime-settings");

			if (Files.exists(settingsFile)) {
				step.skip("Package Control settings already set");
				return;
			}

			Files.createDirectories(settingsFile.getParent());

			FileUtils.write(settingsFile,
					GSON.toJson(Map.of(
							"installed_packages", packageNames
					)));
		}
	}

}
