/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Download;
import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class Firefox {
    public static final Extension EXTENSION_MULTI_ACCOUNT_CONTAINERS = new Extension("@testpilot-containers", URI.create("https://addons.mozilla.org/firefox/downloads/file/4355970/multi_account_containers-8.2.0.xpi"));
    public static final Extension EXTENSION_GRANTED_CONTAINERS = new Extension("{b5e0e8de-ebfe-4306-9528-bcc18241a490}", URI.create("https://addons.mozilla.org/firefox/downloads/file/4086622/granted-1.1.2.xpi"));
    private static final String KEYRING_NAME = "packages.mozilla.org.gpg";

    public static void installOfficial() {
        try (Step step = Step.start("Firefox: Install");){
            Apt.addPublicKey(KEYRING_NAME, URI.create("https://packages.mozilla.org/apt/repo-signing-key.gpg"));
            Apt.addSource("mozilla", "deb [signed-by=/etc/apt/keyrings/%s] https://packages.mozilla.org/apt mozilla main".formatted(KEYRING_NAME));
            Apt.update();
            Apt.install("firefox");
        }
    }

    public static void addDefaultExtensions(Path firefoxInstallDir, List<Extension> extensions) {
        try (Step step = Step.start("Firefox: install extensions");){
            Path externalExtensionsDir = firefoxInstallDir.resolve("distribution/extensions");
            Shell.sudo("mkdir", "-p", externalExtensionsDir.toString());
            for (Extension extension : extensions) {
                Path downloadPath = Download.intoTempFile(extension.downloadUrl);
                Path targetPath = externalExtensionsDir.resolve(extension.id + ".xpi");
                if (Files.exists(targetPath, new LinkOption[0])) continue;
                FileUtils.sudoCopy(downloadPath.toString(), targetPath.toString(), "root:root", "644");
            }
        }
    }

    public record Extension(String id, URI downloadUrl) {
    }
}

