/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api._internal;

import com.droidkit.actors.ActorCreator;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSelection;
import com.droidkit.actors.Props;
import com.droidkit.actors.tasks.TaskActor;
import im.actor.api.ApiRequestException;
import im.actor.api._internal.ApiBrokerActor;
import im.actor.api.parser.Request;
import im.actor.api.parser.Response;

public class RawRequestActor
extends TaskActor<Response> {
    private Request request;
    private ActorRef broker;
    private long id;

    public static ActorSelection request(String path, final long id, final Request request, final ActorRef broker) {
        return new ActorSelection(Props.create(RawRequestActor.class, (ActorCreator)new ActorCreator<RawRequestActor>(){

            public RawRequestActor create() {
                return new RawRequestActor(id, request, broker);
            }
        }), path);
    }

    public RawRequestActor(long id, Request request, ActorRef broker) {
        this.id = id;
        this.request = request;
        this.broker = broker;
    }

    public void startTask() {
        this.broker.send((Object)new ApiBrokerActor.SendRequest(this.id, this.request), this.self());
    }

    public void onReceive(Object message) {
        super.onReceive(message);
        if (message instanceof RpcError) {
            RpcError error = (RpcError)message;
            this.error(new ApiRequestException(error.getErrorCode(), error.getErrorTag(), error.getErrorUserMessage(), error.isCanTryAgain(), error.getRelatedData()));
        } else if (message instanceof RpcResult) {
            this.complete((Object)((RpcResult)message).getResult());
        }
    }

    public void onTaskObsolete() {
        super.onTaskObsolete();
        this.broker.send((Object)new ApiBrokerActor.CancelRequest(this.id));
    }

    public static class RpcResult {
        private Response result;

        public RpcResult(Response result) {
            this.result = result;
        }

        public Response getResult() {
            return this.result;
        }
    }

    public static class RpcError {
        private int errorCode;
        private String errorTag;
        private String errorUserMessage;
        private boolean canTryAgain;
        private byte[] relatedData;

        public RpcError(int errorCode, String errorTag, String errorUserMessage, boolean canTryAgain, byte[] relatedData) {
            this.errorCode = errorCode;
            this.errorTag = errorTag;
            this.errorUserMessage = errorUserMessage;
            this.canTryAgain = canTryAgain;
            this.relatedData = relatedData;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorTag() {
            return this.errorTag;
        }

        public String getErrorUserMessage() {
            return this.errorUserMessage;
        }

        public boolean isCanTryAgain() {
            return this.canTryAgain;
        }

        public byte[] getRelatedData() {
            return this.relatedData;
        }
    }
}

