/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.scheme.rpc;

import com.droidkit.bser.Bser;
import com.droidkit.bser.BserObject;
import com.droidkit.bser.BserValues;
import com.droidkit.bser.BserWriter;
import im.actor.api.parser.Request;
import im.actor.api.scheme.MessageContent;
import im.actor.api.scheme.OutPeer;
import im.actor.api.scheme.rpc.ResponseSeqDate;
import java.io.IOException;

public class RequestSendMessage
extends Request<ResponseSeqDate> {
    public static final int HEADER = 92;
    private OutPeer peer;
    private long rid;
    private MessageContent message;

    public static RequestSendMessage fromBytes(byte[] data) throws IOException {
        return (RequestSendMessage)Bser.parse(RequestSendMessage.class, (byte[])data);
    }

    public RequestSendMessage(OutPeer peer, long rid, MessageContent message) {
        this.peer = peer;
        this.rid = rid;
        this.message = message;
    }

    public RequestSendMessage() {
    }

    public OutPeer getPeer() {
        return this.peer;
    }

    public long getRid() {
        return this.rid;
    }

    public MessageContent getMessage() {
        return this.message;
    }

    public void parse(BserValues values) throws IOException {
        this.peer = (OutPeer)values.getObj(1, OutPeer.class);
        this.rid = values.getLong(3);
        this.message = (MessageContent)values.getObj(4, MessageContent.class);
    }

    public void serialize(BserWriter writer) throws IOException {
        if (this.peer == null) {
            throw new IOException();
        }
        writer.writeObject(1, (BserObject)this.peer);
        writer.writeLong(3, this.rid);
        if (this.message == null) {
            throw new IOException();
        }
        writer.writeObject(4, (BserObject)this.message);
    }

    @Override
    public int getHeaderKey() {
        return 92;
    }
}

