package io.contextmap.annotations.entity;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Annotation to document and create softlink between entities.
 * Either in the current component, or between components.
 */
@Target({ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextSoftLink {

    /**
     * Use this attribute to create a soft-link to an entity in the current component.
     * @return linked entity in current component
     */
    Class entity() default void.class;

    /**
     * Use this attribute in combination with component() to create a soft-link to
     * an entity in another component.
     * The simple name of the entity's class should be used.
     *
     * @return name of the linked entity to other component
     */
    String entityName() default "";

    /**
     * Use this attribute in combination with entityName() to create a soft-link to
     * an entity in another component.
     *
     * @return name of the other component
     */
    String component() default "";


}
