/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapi.CronapiSearchable;
import cronapi.QueryManager;
import cronapi.Utils;
import cronapi.odata.server.DatasourceOperations;
import cronapi.odata.server.JPQLParserUtil;
import cronapi.util.Functions;
import cronapi.util.JsonUtil;
import cronapi.util.Operations;
import cronapi.util.ReflectionUtils;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.api.edm.provider.Documentation;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.Key;
import org.apache.olingo.odata2.api.edm.provider.Mapping;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.core.CloneUtils;
import org.apache.olingo.odata2.core.edm.EdmSimpleTypeFacadeImpl;
import org.apache.olingo.odata2.core.edm.EdmString;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmExtension;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAConfig;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClass;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPATypeConverter;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.jpql.HermesParser;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.DefaultEclipseLinkJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceExtension
implements JPAEdmExtension {
    private static final Logger log = LoggerFactory.getLogger(DatasourceExtension.class);
    public static final String TIMESTAMP = "TIMESTAMP";
    private static String JSON_HASH = "";
    public static Set<String> GRID_PREFERED_FIELDS = new HashSet<String>();
    public static final String JPQL = "jpql";
    private final EntityManagerImpl em;
    private int order;
    private String jpql;
    private boolean isNative = false;
    private EntityType jpqlEntity;
    public static Pattern PLAIN_EXPRESSION;

    public DatasourceExtension(ODataJPAContext context, int order) {
        this((EntityManagerImpl)context.getEntityManager(), order);
    }

    public DatasourceExtension(EntityManagerImpl em, int order) {
        this.em = em;
        this.order = order;
    }

    public void jpql(String jpql, boolean isNative) {
        this.jpql = jpql;
        this.isNative = isNative;
    }

    public EntityType getJpqlEntity() {
        return this.jpqlEntity;
    }

    public void extendWithOperation(JPAEdmSchemaView jpaEdmSchemaView) {
        jpaEdmSchemaView.registerOperations(DatasourceOperations.class, null);
    }

    public void extendJPAEdmSchema(JPAEdmSchemaView view) {
        this.extendJPAEdmSchema(view.getEdmSchema());
    }

    public void extendJPAEdmSchema(Schema edmSchema) {
        if (edmSchema.getEntityTypes() == null) {
            edmSchema.setEntityTypes(new LinkedList());
        }
        if (this.jpql != null) {
            if (this.isNative) {
                this.createSQLDataSource(edmSchema, JPQL, this.jpql, null, null, null);
            } else {
                this.createJpqlDataSource(edmSchema, JPQL, this.jpql, null, null, null);
            }
            for (EntityType type : edmSchema.getEntityTypes()) {
                if (!type.getName().equals(JPQL)) {
                    type.setShowMetadata(false);
                    continue;
                }
                this.jpqlEntity = type;
            }
            for (EntityContainer container : edmSchema.getEntityContainers()) {
                for (EntitySet entitySet : container.getEntitySets()) {
                    entitySet.setShowMetadata(false);
                }
            }
        } else {
            for (Object set : ((EntityContainer)edmSchema.getEntityContainers().get(0)).getEntitySets()) {
                set.setShowMetadata(AppConfig.exposeLocalEntities());
            }
            LinkedList<EntityType> localEntities = new LinkedList<EntityType>();
            for (EntityType type : edmSchema.getEntityTypes()) {
                localEntities.add(type);
            }
            LinkedList<EntitySet> queryDatasource = new LinkedList<EntitySet>();
            JsonObject queries = QueryManager.getJSON();
            boolean throwsError = true;
            if (Operations.IS_DEBUG) {
                try {
                    String hash = Utils.encodeMD5(queries.toString());
                    if (hash.equals(JSON_HASH)) {
                        throwsError = false;
                    }
                    JSON_HASH = hash;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            for (Map.Entry entry : queries.entrySet()) {
                EntitySet set;
                CalcField field;
                JsonObject calcObj;
                JsonObject customObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                LinkedList<CalcField> calcFields = new LinkedList<CalcField>();
                JsonElement elem = customObj.get("originalId");
                String originalId = null;
                if (!JsonUtil.isNull(elem)) {
                    originalId = elem.getAsString();
                }
                if (!QueryManager.isNull(customObj.get("calcFieldsProperties"))) {
                    if (!QueryManager.isNull(customObj.get("calcFieldsProperties"))) {
                        calcObj = customObj.get("calcFieldsProperties").getAsJsonObject();
                        for (Map.Entry entryObj : calcObj.entrySet()) {
                            JsonElement value;
                            field = new CalcField();
                            field.name = (String)entryObj.getKey();
                            field.type = ((JsonElement)entryObj.getValue()).getAsJsonObject().get("type").getAsString();
                            if (!QueryManager.isNull(customObj.get("calcFields")) && !QueryManager.isNull(value = customObj.get("calcFields").getAsJsonObject().get(field.name)) && value.isJsonPrimitive() && value.getAsJsonPrimitive().isString() && StringUtils.isNotEmpty((CharSequence)value.getAsString())) {
                                field.expression = value.getAsString();
                            }
                            calcFields.add(field);
                        }
                    }
                } else if (!QueryManager.isNull(customObj.get("calcFields"))) {
                    calcObj = customObj.get("calcFields").getAsJsonObject();
                    for (Map.Entry entryObj : calcObj.entrySet()) {
                        field = new CalcField();
                        field.name = (String)entryObj.getKey();
                        calcFields.add(field);
                    }
                }
                if (!QueryManager.isNull(customObj.get("entityFullName"))) {
                    String clazz = customObj.get("entityFullName").getAsString();
                    if (!clazz.startsWith(edmSchema.getNamespace() + ".")) continue;
                    try {
                        set = this.createDataSource(edmSchema, customObj.get("customId").getAsString(), customObj.get("entitySimpleName").getAsString(), calcFields, customObj);
                        if (set == null) continue;
                        set.setAlternativeName(originalId);
                        queryDatasource.add(set);
                    }
                    catch (Exception e) {
                        if (!throwsError) continue;
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (!QueryManager.isNull(customObj.get("baseEntity"))) {
                    String baseEntity = customObj.get("baseEntity").getAsString();
                    if (!baseEntity.startsWith(edmSchema.getNamespace() + ".")) continue;
                    try {
                        set = this.createBlocklyDataSource(edmSchema, customObj.get("customId").getAsString(), customObj, calcFields, customObj);
                        if (set == null) continue;
                        set.setAlternativeName(originalId);
                        queryDatasource.add(set);
                    }
                    catch (Exception e) {
                        if (!throwsError) continue;
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (!QueryManager.isNull(customObj.get("connection"))) {
                    String connection = customObj.get("connection").getAsString();
                    if (!connection.equals(edmSchema.getNamespace())) continue;
                    try {
                        set = this.createBlocklyDataSource(edmSchema, customObj.get("customId").getAsString(), customObj, calcFields, customObj);
                        if (set == null) continue;
                        set.setAlternativeName(originalId);
                        queryDatasource.add(set);
                    }
                    catch (Exception e) {
                        if (!throwsError) continue;
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (this.order != 0) continue;
                try {
                    EntitySet set2 = this.createBlocklyDataSource(edmSchema, customObj.get("customId").getAsString(), customObj, calcFields, customObj);
                    if (set2 == null) continue;
                    set2.setAlternativeName(originalId);
                    queryDatasource.add(set2);
                }
                catch (Exception e) {
                    if (!throwsError) continue;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (!AppConfig.exposeLocalEntities()) {
                ((EntityContainer)edmSchema.getEntityContainers().get(0)).getAssociationSets().clear();
                for (EntityType type : edmSchema.getEntityTypes()) {
                    if (type.getNavigationProperties() == null) continue;
                    type.getNavigationProperties().clear();
                }
            }
            for (EntityType type : localEntities) {
                JPAEdmMappingImpl mapping = (JPAEdmMappingImpl)type.getMapping();
                if (mapping == null || mapping.isVirtualAccess()) continue;
                this.addDisplayFields(edmSchema, type);
            }
            for (EntityType type : edmSchema.getEntityTypes()) {
                type.setShowMetadata(AppConfig.exposeMetadada());
            }
            for (EntityContainer container : edmSchema.getEntityContainers()) {
                for (EntitySet set : container.getEntitySets()) {
                    set.setShowMetadata(AppConfig.exposeMetadada());
                }
            }
        }
    }

    private static boolean isEdmSimpleTypeKind(Class fieldClass) {
        try {
            JPATypeConverter.convertToEdmSimpleType((Class)fieldClass, null);
            return false;
        }
        catch (ODataJPAModelException e) {
            return true;
        }
    }

    private static EdmSimpleTypeKind toEdmSimpleTypeKind(Class fieldClass) {
        try {
            return JPATypeConverter.convertToEdmSimpleType((Class)fieldClass, null);
        }
        catch (ODataJPAModelException e) {
            return EdmSimpleTypeKind.Auto;
        }
    }

    private static EdmSimpleTypeKind toEdmSimpleTypeKind(String fieldClass) {
        return Enum.valueOf(EdmSimpleTypeKind.class, fieldClass);
    }

    private EntityType findEntityType(Schema edmSchema, String entity) {
        for (EntityType type : edmSchema.getEntityTypes()) {
            if (!type.getName().equals(entity)) continue;
            return type;
        }
        return null;
    }

    private PropertyRef findKey(EntityType entityType, String name) {
        for (PropertyRef item : entityType.getKey().getKeys()) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    private boolean isOriginalKey(EntityType entityType, String name) {
        for (Property item : entityType.getProperties()) {
            if (!item.getName().equals(name) || !item.isOriginalId()) continue;
            return true;
        }
        return false;
    }

    private List<Property> findOriginalKeys(EntityType entityType) {
        LinkedList<Property> keys = new LinkedList<Property>();
        for (PropertyRef item : entityType.getKey().getKeys()) {
            Property property = this.findProperty(entityType, item.getName());
            if (property == null) continue;
            if (property.getComposite() != null) {
                keys.addAll(property.getComposite());
                continue;
            }
            keys.add(property);
        }
        return keys;
    }

    private Property findProperty(EntityType entityType, String name) {
        for (Property item : entityType.getProperties()) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    private void addCalcFields(EntityType newType, List<CalcField> addFields, String mainAlias, boolean addAlias) {
        if (addFields != null) {
            for (CalcField field : addFields) {
                SimpleProperty property = new SimpleProperty();
                EdmSimpleTypeKind kind = field.type != null && !field.type.isEmpty() ? EdmSimpleTypeKind.valueOf((String)field.type) : EdmSimpleTypeKind.Auto;
                property.setType(kind);
                property.setName(field.name);
                JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
                mapping.setUpdatable(false);
                mapping.setInternalName(field.name);
                if (StringUtils.isNotEmpty((CharSequence)mainAlias) && StringUtils.isNotEmpty((CharSequence)field.expression) && field.expression.startsWith("this.")) {
                    if (addAlias) {
                        mapping.setVirtualAccess(true);
                        mapping.setInternalExpression(mainAlias + "." + field.expression.substring(5));
                    } else {
                        mapping.setInternalName(field.expression.substring(5));
                    }
                } else {
                    mapping.setCalculated(true);
                    mapping.setVirtualAccess(true);
                }
                mapping.setJPAType(EdmSimpleTypeFacadeImpl.getEdmClassType((EdmSimpleTypeKind)kind));
                property.setMapping((Mapping)mapping);
                Facets facets = new Facets();
                facets.setNullable(Boolean.valueOf(true));
                property.setFacets((EdmFacets)facets);
                newType.getProperties().add(property);
            }
        }
    }

    public static boolean isPreferedDisplayField(String name) {
        for (String pref : GRID_PREFERED_FIELDS) {
            if (!name.matches(pref)) continue;
            return true;
        }
        return false;
    }

    private Property findBestDisplayField(EntityType complexType) {
        PropertyRef key;
        JPAEdmMappingImpl mapping;
        Field[] fields;
        if (!ODataJPAConfig.ADD_DISPLAY_FIELDS) {
            return null;
        }
        Class clazz = ((JPAEdmMappingImpl)complexType.getMapping()).getJPAType();
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                CronapiSearchable searchable = field.getAnnotation(CronapiSearchable.class);
                if (searchable == null) continue;
                return this.findProperty(complexType, field.getName());
            }
            catch (Exception searchable) {
                // empty catch block
            }
        }
        Property best = null;
        for (Property p : complexType.getProperties()) {
            mapping = (JPAEdmMappingImpl)p.getMapping();
            key = this.findKey(complexType, p.getName());
            if (key != null || p.isOriginalId() || p.getOriginalType() != null || mapping.getJPAType() != String.class || !DatasourceExtension.isPreferedDisplayField(p.getName())) continue;
            best = p;
            break;
        }
        if (best == null) {
            for (Property p : complexType.getProperties()) {
                mapping = (JPAEdmMappingImpl)p.getMapping();
                key = this.findKey(complexType, p.getName());
                if (key != null || p.isOriginalId() || p.getOriginalType() != null || mapping.getJPAType() != String.class) continue;
                best = p;
                break;
            }
        }
        if (best == null) {
            for (Property p : complexType.getProperties()) {
                mapping = (JPAEdmMappingImpl)p.getMapping();
                key = this.findKey(complexType, p.getName());
                boolean isComplex = DatasourceExtension.isEdmSimpleTypeKind(mapping.getJPAType());
                if (key != null || p.isOriginalId() || p.getOriginalType() != null || isComplex) continue;
                best = p;
                break;
            }
        }
        return best;
    }

    private void addDisplayFields(Schema edmSchema, EntityType type) {
        if (!ODataJPAConfig.ADD_DISPLAY_FIELDS) {
            return;
        }
        LinkedList properties = new LinkedList();
        properties.addAll(type.getProperties());
        for (Property p : properties) {
            SimpleProperty best;
            JPAEdmMappingImpl mapping = (JPAEdmMappingImpl)p.getMapping();
            EntityType complexType = null;
            if (p.getOriginalType() != null) {
                complexType = this.findEntityType(edmSchema, p.getOriginalType().getSimpleName());
            }
            if (complexType == null || (best = (SimpleProperty)this.findBestDisplayField(complexType)) == null) continue;
            SimpleProperty newProp = (SimpleProperty)CloneUtils.getClone((Object)p);
            newProp.setComposite(null);
            newProp.setName(newProp.getName() + "_" + best.getName());
            newProp.setType(best.getType());
            newProp.setDisplayField(true);
            ((Facets)newProp.getFacets()).setNullable(Boolean.valueOf(true));
            JPAEdmMappingImpl newMapping = (JPAEdmMappingImpl)CloneUtils.getClone((Object)p.getMapping());
            if (newMapping.getInternalName().contains(".")) {
                newMapping.setInternalName(newMapping.getInternalName().substring(0, newMapping.getInternalName().lastIndexOf(".")) + "." + best.getName());
            } else {
                newMapping.setInternalName(newMapping.getInternalName() + "." + best.getName());
            }
            newProp.setMapping((Mapping)newMapping);
            int total = 0;
            String name = newProp.getName();
            for (Property prop : type.getProperties()) {
                if (!prop.getName().equals(name) && !prop.getName().startsWith(name + "_")) continue;
                ++total;
            }
            if (total > 0) {
                newProp.setName(name + "_" + total);
            }
            type.getProperties().add(newProp);
        }
    }

    private SimpleProperty addProperty(String alias, EntityType mainType, Schema edmSchema, Class type, String orgName, String internalName, String expression, List<Property> properties, List<PropertyRef> propertyRefList, String complexPath, int complexIndex, String mainAlias, String columnDefinition) {
        boolean isComplex = DatasourceExtension.isEdmSimpleTypeKind(type);
        EntityType complexType = null;
        if (isComplex) {
            complexType = this.findEntityType(edmSchema, type.getSimpleName());
        }
        if (complexType != null) {
            if (orgName.equals(mainAlias) && alias == null) {
                for (Property property : complexType.getProperties()) {
                    SimpleProperty best;
                    if (property.getName().equals(ODataJPAConfig.COMPOSITE_KEY_NAME)) continue;
                    Property newProperty = (Property)CloneUtils.getClone((Object)property);
                    properties.add(newProperty);
                    newProperty.setName(newProperty.getName());
                    newProperty.setMapping((Mapping)CloneUtils.getClone((Object)property.getMapping()));
                    JPAEdmMappingImpl mapping = (JPAEdmMappingImpl)newProperty.getMapping();
                    mapping.setVirtualAccess(true);
                    mapping.setInternalName(mainAlias + "." + mapping.getInternalName());
                    mapping.setInternalExpression(expression + "." + property.getMapping().getInternalName());
                    mapping.setComplexIndex(complexIndex);
                    newProperty.setForeignKey(true);
                    if (property.getOriginalType() == null) continue;
                    if (property.getComposite() != null) {
                        newProperty.setComposite(null);
                        for (Property c : property.getComposite()) {
                            Property newComposite = (Property)CloneUtils.getClone((Object)c);
                            JPAEdmMappingImpl compositeMapping = (JPAEdmMappingImpl)newComposite.getMapping();
                            newComposite.setName(mainAlias + "_" + c.getName());
                            compositeMapping.setInternalName(mainAlias + "." + compositeMapping.getInternalName());
                            compositeMapping.setInternalExpression(expression + "." + c.getMapping().getInternalName());
                            compositeMapping.setComplexIndex(complexIndex);
                            compositeMapping.setVirtualAccess(true);
                            newComposite.setForeignKey(true);
                            newProperty.addComposite(newComposite);
                        }
                    }
                    if ((best = (SimpleProperty)this.findBestDisplayField(this.findEntityType(edmSchema, newProperty.getOriginalType().getSimpleName()))) == null) continue;
                    if (property.getComposite() != null) {
                        this.addProperty(orgName, mainType, edmSchema, ((JPAEdmMappingImpl)best.getMapping()).getJPAType(), newProperty.getName() + "_" + best.getName(), mapping.getInternalName() + "." + best.getName(), mapping.getInternalExpression() + "." + best.getName(), properties, propertyRefList, expression, complexIndex, mainAlias, best.getColumnDefinition());
                        continue;
                    }
                    this.addProperty(orgName, mainType, edmSchema, ((JPAEdmMappingImpl)best.getMapping()).getJPAType(), newProperty.getName() + "_" + best.getName(), mapping.getInternalName().substring(0, mapping.getInternalName().lastIndexOf(".")) + "." + best.getName(), mapping.getInternalExpression().substring(0, mapping.getInternalName().lastIndexOf(".")) + "." + best.getName(), properties, propertyRefList, expression, complexIndex, mainAlias, best.getColumnDefinition());
                }
                return null;
            }
            String internalExpression = expression.substring(expression.indexOf(".") + 1);
            List<Property> keys = this.findOriginalKeys(complexType);
            String prefix = alias != null ? alias : internalExpression.replace(".", "_");
            SimpleProperty added = this.addProperty(orgName, mainType, edmSchema, keys.size() == 1 && keys.get(0).getMapping() != null && ((JPAEdmMappingImpl)keys.get(0).getMapping()).getOriginaType() != null ? ((JPAEdmMappingImpl)keys.get(0).getMapping()).getOriginaType() : String.class, prefix, "[name]." + orgName, expression + "." + orgName, properties, propertyRefList, expression, complexIndex, mainAlias, "");
            for (Property key : keys) {
                Property newKey = (Property)CloneUtils.getClone((Object)key);
                EdmFacets facets = (EdmFacets)CloneUtils.getClone((Object)newKey.getFacets());
                ((Facets)facets).setNullable(Boolean.valueOf(true));
                newKey.setFacets(facets);
                newKey.setName(added.getName() + "_" + newKey.getName());
                newKey.setMapping((Mapping)CloneUtils.getClone((Object)key.getMapping()));
                JPAEdmMappingImpl mapping = (JPAEdmMappingImpl)newKey.getMapping();
                mapping.setVirtualAccess(true);
                mapping.setInternalName(added.getName() + "." + mapping.getInternalName());
                mapping.setInternalExpression(expression + "." + key.getMapping().getInternalName());
                newKey.setForeignKey(true);
                added.addComposite(newKey);
                if (!ODataJPAConfig.EXPAND_COMPOSITE_KEYS) continue;
                properties.add(newKey);
            }
            SimpleProperty best = (SimpleProperty)this.findBestDisplayField(complexType);
            if (best != null) {
                this.addProperty(orgName, mainType, edmSchema, ((JPAEdmMappingImpl)best.getMapping()).getJPAType(), added.getName() + "_" + best.getName(), added.getName() + "." + best.getName(), expression + "." + best.getName(), properties, propertyRefList, expression, complexIndex, mainAlias, best.getColumnDefinition());
            }
        } else {
            String path;
            int count = StringUtils.countMatches((CharSequence)expression, (CharSequence)".");
            boolean useExpression = false;
            if (alias == null && count > 1) {
                useExpression = true;
            }
            SimpleProperty property = new SimpleProperty();
            property.setType(DatasourceExtension.toEdmSimpleTypeKind(type));
            property.setColumnDefinition(columnDefinition);
            boolean plainExpression = PLAIN_EXPRESSION.matcher(expression).matches();
            if (useExpression) {
                if (plainExpression) {
                    orgName = expression.substring(expression.indexOf(".") + 1).replace(".", "_");
                }
                internalName = orgName;
            }
            property.setName(orgName);
            int total = 0;
            Object name = orgName;
            for (Property prop : properties) {
                if (!prop.getName().equals(name)) continue;
                name = property.getName() + "_" + ++total;
            }
            if (total > 0) {
                property.setName((String)name);
            }
            JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
            mapping.setInternalExpression(expression);
            mapping.setInternalName(internalName.replace("[name]", property.getName()));
            mapping.setJPAType(type);
            mapping.setVirtualAccess(true);
            if (complexPath != null) {
                path = complexPath.substring(complexPath.indexOf(".") + 1);
                mapping.setComplexPath(path);
            }
            mapping.setComplexIndex(complexIndex);
            if (plainExpression && count > 1) {
                mapping.setIsPath(true);
                path = expression.substring(expression.indexOf(".") + 1);
                path = path.substring(path.indexOf(".") + 1);
                mapping.setPath(path);
            }
            property.setMapping((Mapping)mapping);
            properties.add((Property)property);
            return property;
        }
        return null;
    }

    private EntitySet createBlocklyDataSource(Schema edmSchema, String id, JsonObject entity, List<CalcField> addFields, JsonObject customObj) {
        PropertyRef propertyRef;
        if (!QueryManager.isNull(entity.get("baseEntity"))) {
            String baseEntity = entity.get("baseEntity").getAsString();
            if (baseEntity.contains(".")) {
                baseEntity = baseEntity.substring(baseEntity.lastIndexOf(".") + 1);
            }
            return this.createEntityDataSource(edmSchema, id, baseEntity, addFields, customObj);
        }
        String edmNamespace = edmSchema.getNamespace();
        EntitySet set = new EntitySet();
        set.setName(id);
        set.setEntityType(new FullQualifiedName(edmNamespace, id));
        ((EntityContainer)edmSchema.getEntityContainers().get(0)).getEntitySets().add(set);
        Key key = new Key();
        ArrayList<PropertyRef> propertyRefList = new ArrayList<PropertyRef>();
        key.setKeys(propertyRefList);
        ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
        LinkedList<Object> keys = new LinkedList<Object>();
        boolean keysSet = false;
        JsonElement defaultValuesPropertiesElement = entity.get("defaultValuesProperties");
        boolean hasObjectKey = false;
        if (defaultValuesPropertiesElement != null) {
            JsonObject obj = defaultValuesPropertiesElement.getAsJsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                if (!((String)entry.getKey()).equals(ODataJPAConfig.COMPOSITE_KEY_NAME)) continue;
                hasObjectKey = true;
            }
            for (Map.Entry entry : obj.entrySet()) {
                JsonObject propObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                SimpleProperty property = new SimpleProperty();
                property.setName((String)entry.getKey());
                EdmSimpleTypeKind type = EdmSimpleTypeKind.valueOf((String)propObj.get("type").getAsString());
                property.setType(type);
                JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
                mapping.setJPAType(type.getEdmSimpleTypeInstance().getDefaultType());
                mapping.setVirtualAccess(true);
                mapping.setInternalExpression((String)entry.getKey());
                if (!JsonUtil.isNull(entity.get("sourceType")) && entity.get("sourceType").getAsString().equals("native") && !JsonUtil.isNull(propObj.get("path"))) {
                    mapping.setInternalExpression(Functions.unquote(propObj.get("path").getAsString()));
                }
                if (!JsonUtil.isNull(propObj.get("updatable"))) {
                    mapping.setUpdatable(propObj.get("updatable").getAsBoolean());
                }
                Facets facets = new Facets();
                if (!JsonUtil.isNull(propObj.get("nullable"))) {
                    facets.setNullable(Boolean.valueOf(propObj.get("nullable").getAsBoolean()));
                }
                if (!JsonUtil.isNull(propObj.get("autogenerated"))) {
                    facets.setAutoGenerated(Boolean.valueOf(propObj.get("autogenerated").getAsBoolean()));
                }
                if (!JsonUtil.isNull(propObj.get("length"))) {
                    facets.setMaxLength(Integer.valueOf(propObj.get("length").getAsInt()));
                }
                if (!JsonUtil.isNull(propObj.get("scale"))) {
                    facets.setScale(Integer.valueOf(propObj.get("scale").getAsInt()));
                }
                if (!JsonUtil.isNull(propObj.get("precision"))) {
                    facets.setPrecision(Integer.valueOf(propObj.get("precision").getAsInt()));
                }
                if (!JsonUtil.isNull(propObj.get("defaultValue"))) {
                    facets.setDefaultValue(propObj.get("defaultValue").getAsString());
                }
                if (!JsonUtil.isNull(propObj.get("index"))) {
                    mapping.setIndex(Integer.valueOf(propObj.get("index").getAsInt()));
                }
                property.setFacets((EdmFacets)facets);
                property.setMapping((Mapping)mapping);
                properties.add(property);
                if (!((JsonElement)entry.getValue()).getAsJsonObject().get("key").getAsBoolean()) continue;
                keys.add(property);
                property.setOriginalId(true);
                facets.setCollation("key");
                keysSet = true;
            }
        }
        boolean canEdit = true;
        if (!keysSet) {
            propertyRefList.clear();
            canEdit = false;
            for (Property property : properties) {
                property.setOriginalId(true);
                if (property.getFacets() != null) {
                    ((Facets)property.getFacets()).setCollation("key");
                }
                keys.add(property);
            }
        }
        if (!hasObjectKey) {
            SimpleProperty objectKey = new SimpleProperty();
            objectKey.setName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            objectKey.setType(EdmSimpleTypeKind.String);
            JPAEdmMappingImpl jPAEdmMappingImpl = new JPAEdmMappingImpl();
            jPAEdmMappingImpl.setInternalName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            jPAEdmMappingImpl.setJPAType(EdmString.class);
            jPAEdmMappingImpl.setVirtualAccess(true);
            objectKey.setMapping((Mapping)jPAEdmMappingImpl);
            objectKey.setComposite(keys);
            propertyRef = new PropertyRef();
            propertyRef.setName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            propertyRefList.add(propertyRef);
            properties.add(objectKey);
        } else {
            for (Property property : keys) {
                propertyRef = new PropertyRef();
                propertyRef.setName(property.getName());
                propertyRefList.add(propertyRef);
            }
        }
        EntityType type = new EntityType();
        type.setProperties(properties);
        type.setKey(key);
        type.setName(id);
        JPAEdmMappingImpl jPAEdmMappingImpl = new JPAEdmMappingImpl();
        jPAEdmMappingImpl.setCanEdit(canEdit);
        jPAEdmMappingImpl.setJPAType(VirtualClass.class);
        if (customObj != null && customObj.get("plugin") != null && customObj.get("plugin").getAsBoolean()) {
            Documentation doc = new Documentation();
            doc.setLongDescription(customObj.toString());
            type.setDocumentation(doc);
        }
        jPAEdmMappingImpl.setVirtualAccess(true);
        if (canEdit || !JsonUtil.isNull(entity.get("sourceType")) && entity.get("sourceType").getAsString().equals("native")) {
            jPAEdmMappingImpl.setInternalName(id);
        }
        type.setMapping((Mapping)jPAEdmMappingImpl);
        this.addCalcFields(type, addFields, null, false);
        edmSchema.getEntityTypes().add(type);
        return set;
    }

    private EntitySet createDataSource(Schema edmSchema, String id, String entity, List<CalcField> addFields, JsonObject customObj) {
        JsonObject queryJson = QueryManager.getQuery(id);
        String jpql = QueryManager.getJPQL(queryJson, false);
        return this.createJpqlDataSource(edmSchema, id, jpql, entity, addFields, customObj);
    }

    public String expandJPQL(String jpql, Schema edmSchema) {
        AbstractSession session = this.em.getActiveSessionIfExists();
        HermesParser parser = new HermesParser();
        ReportQuery reportQuery = (ReportQuery)parser.buildQuery((CharSequence)jpql, session);
        reportQuery.prepareInternal(session);
        JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpql, DefaultEclipseLinkJPQLGrammar.instance(), true);
        ListIterable children = ((SelectClause)((SelectStatement)jpqlExpression.getQueryStatement()).getSelectClause()).getSelectExpression().children();
        ListIterator expressions = children.iterator();
        SelectStatement selectStatement = (SelectStatement)jpqlExpression.getQueryStatement();
        LinkedList<Object> selectResult = new LinkedList<Object>();
        boolean changed = false;
        String mainAlias = JPQLParserUtil.getMainAlias(jpqlExpression);
        for (ReportItem item : reportQuery.getItems()) {
            Expression expression;
            String alias = null;
            Expression originalExpression = expression = (Expression)expressions.next();
            if (expression instanceof IdentificationVariable && !(expression.getParent() instanceof CollectionExpression)) {
                expression = expression.getParent();
            }
            if (expression instanceof ResultVariable) {
                if (((ResultVariable)expression).getResultVariable() != null) {
                    alias = ((ResultVariable)expression).getResultVariable().toActualText();
                }
                expression = ((ResultVariable)expression).getSelectExpression();
            }
            Class type = Object.class;
            if (item.getMapping() != null) {
                type = item.getMapping().getField().getType();
            } else if (item.getDescriptor() != null) {
                type = item.getDescriptor().getJavaClass();
            } else if (item.getResultType() != null) {
                type = item.getResultType();
            } else if (item.getAttributeExpression() instanceof SubSelectExpression) {
                List subItens = ((SubSelectExpression)item.getAttributeExpression()).getSubQuery().getItems();
                if (subItens.size() == 1) {
                    type = ((ReportItem)subItens.get(0)).getResultType();
                } else if (subItens.size() > 1) {
                    throw new RuntimeException("Error in JPA subquery!");
                }
            } else if (item.getAttributeExpression() instanceof ConstantExpression && ((ConstantExpression)item.getAttributeExpression()).getValue() != null) {
                type = ((ConstantExpression)item.getAttributeExpression()).getValue().getClass();
            }
            boolean isComplex = DatasourceExtension.isEdmSimpleTypeKind(type);
            EntityType complexType = null;
            if (isComplex) {
                complexType = this.findEntityType(edmSchema, type.getSimpleName());
            }
            if (complexType != null) {
                if (mainAlias.equals(expression.toString())) {
                    for (Property prop : complexType.getProperties()) {
                        if (prop.getComposite() != null) continue;
                        String reportItem = expression + "." + prop.getMapping().getInternalName();
                        if (!StringUtils.isEmpty((CharSequence)alias)) {
                            reportItem = reportItem + " as " + alias + "_" + prop.getName();
                        }
                        selectResult.add(reportItem);
                    }
                    changed = true;
                    continue;
                }
                selectResult.add(originalExpression.toString());
                continue;
            }
            selectResult.add(originalExpression.toString());
        }
        if (changed) {
            ReflectionUtils.setField(selectStatement, "selectClause", null);
            return "SELECT " + StringUtils.join(selectResult, (String)", ") + " " + jpqlExpression.toString();
        }
        return jpql;
    }

    public Class getClassFromColumnDefinition(DatabaseField field) {
        if (TIMESTAMP.equals(field.getColumnDefinition())) {
            return Long.class;
        }
        return null;
    }

    public EntitySet createJpqlDataSource(Schema edmSchema, String id, String jpql, String entity, List<CalcField> addFields, JsonObject customObj) {
        String edmNamespace = edmSchema.getNamespace();
        HermesParser parser = new HermesParser();
        AbstractSession session = this.em.getActiveSessionIfExists();
        DatabaseQuery query = parser.buildQuery((CharSequence)jpql, session);
        if (query instanceof ReportQuery) {
            List<Property> originalKeys;
            ReportQuery reportQuery = (ReportQuery)parser.buildQuery((CharSequence)jpql, session);
            reportQuery.prepareInternal(session);
            if (reportQuery.getItems().size() == 1 && ((ReportItem)reportQuery.getItems().get(0)).getDescriptor() != null) {
                entity = ((ReportItem)reportQuery.getItems().get(0)).getDescriptor().getJavaClass().getSimpleName();
                return this.createEntityDataSource(edmSchema, id, entity, addFields, customObj);
            }
            String newJpql = jpql;
            boolean changed = false;
            if (!newJpql.equals(jpql)) {
                changed = true;
                jpql = newJpql;
                reportQuery = (ReportQuery)parser.buildQuery((CharSequence)jpql, session);
                reportQuery.prepareInternal(session);
            }
            JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpql, DefaultEclipseLinkJPQLGrammar.instance(), true);
            String mainEntity = JPQLParserUtil.getMainEntity(jpqlExpression);
            String mainAlias = JPQLParserUtil.getMainAlias(jpqlExpression);
            EntityType mainType = this.findEntityType(edmSchema, mainEntity);
            EntitySet set = new EntitySet();
            set.setName(id);
            set.setEntityType(new FullQualifiedName(edmNamespace, id));
            ((EntityContainer)edmSchema.getEntityContainers().get(0)).getEntitySets().add(set);
            ListIterable children = ((SelectClause)((SelectStatement)jpqlExpression.getQueryStatement()).getSelectClause()).getSelectExpression().children();
            ListIterator expressions = children.iterator();
            Key key = new Key();
            LinkedList<PropertyRef> propertyRefList = new LinkedList<PropertyRef>();
            key.setKeys(propertyRefList);
            LinkedList<Property> properties = new LinkedList<Property>();
            AbstractList keys = new LinkedList<Property>();
            int index = -1;
            for (Object item : reportQuery.getItems()) {
                String name;
                ++index;
                String alias = null;
                Object expression = (Expression)expressions.next();
                if (expression instanceof IdentificationVariable && !(expression.getParent() instanceof CollectionExpression)) {
                    expression = expression.getParent();
                }
                if (expression instanceof ResultVariable) {
                    if (((ResultVariable)expression).getResultVariable() != null) {
                        alias = ((ResultVariable)expression).getResultVariable().toActualText();
                    }
                    expression = ((ResultVariable)expression).getSelectExpression();
                }
                Class type = Object.class;
                if (item.getMapping() != null) {
                    type = item.getMapping().getField().getType();
                    if (type == null && (type = this.getClassFromColumnDefinition(item.getMapping().getField())) == null) {
                        type = item.getMapping().getAttributeClassification();
                    }
                } else if (item.getDescriptor() != null) {
                    type = item.getDescriptor().getJavaClass();
                } else if (item.getResultType() != null) {
                    type = item.getResultType();
                } else if (item.getAttributeExpression() instanceof SubSelectExpression) {
                    List subItens = ((SubSelectExpression)item.getAttributeExpression()).getSubQuery().getItems();
                    if (subItens.size() == 1) {
                        type = ((ReportItem)subItens.get(0)).getResultType();
                    } else if (subItens.size() > 1) {
                        throw new RuntimeException("Error in JPA subquery!");
                    }
                } else if (item.getAttributeExpression() instanceof ConstantExpression && ((ConstantExpression)item.getAttributeExpression()).getValue() != null) {
                    type = ((ConstantExpression)item.getAttributeExpression()).getValue().getClass();
                }
                if ((name = item.getName()) == null || name.isEmpty()) {
                    name = "expression";
                }
                String columnDefinition = null;
                if (item.getMapping() != null && item.getMapping().getField() != null) {
                    columnDefinition = item.getMapping().getField().getColumnDefinition();
                }
                this.addProperty(alias, mainType, edmSchema, type, name, name, expression.toString(), properties, propertyRefList, null, index, mainAlias, columnDefinition);
            }
            boolean canEdit = true;
            canEdit = false;
            for (Property item : properties) {
                if (!this.isOriginalKey(mainType, item.getName())) continue;
                if (item.getComposite() != null) {
                    for (Property c : item.getComposite()) {
                        keys.add(c);
                    }
                    continue;
                }
                keys.add(item);
            }
            if (keys.size() == 0) {
                for (Property item : properties) {
                    if (item.getComposite() != null) {
                        for (Property c : item.getComposite()) {
                            keys.add(c);
                        }
                        continue;
                    }
                    keys.add(item);
                }
            }
            if ((originalKeys = this.findOriginalKeys(mainType)).size() == keys.size()) {
                ArrayList<Property> sortedKeys = new ArrayList<Property>(keys.size());
                boolean replace = true;
                for (int i = 0; i < originalKeys.size(); ++i) {
                    Property original = originalKeys.get(i);
                    Optional<Property> found = keys.stream().filter(a -> a.getMapping() != null && a.getMapping().getInternalName() != null && original.getMapping() != null && original.getMapping().getInternalName() != null && a.getMapping().getInternalName().equals(original.getMapping().getInternalName())).findFirst();
                    if (!found.isPresent()) {
                        replace = false;
                        break;
                    }
                    sortedKeys.add(i, found.get());
                }
                if (replace) {
                    keys = sortedKeys;
                }
                canEdit = true;
            }
            SimpleProperty objectKey = new SimpleProperty();
            objectKey.setName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            objectKey.setType(EdmSimpleTypeKind.String);
            JPAEdmMappingImpl keymapping = new JPAEdmMappingImpl();
            keymapping.setInternalName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            keymapping.setJPAType(EdmString.class);
            keymapping.setVirtualAccess(true);
            objectKey.setMapping((Mapping)keymapping);
            objectKey.setComposite((List)keys);
            PropertyRef propertyRef = new PropertyRef();
            propertyRef.setName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            propertyRefList.add(propertyRef);
            properties.add((Property)objectKey);
            EntityType type = new EntityType();
            if (customObj != null && customObj.get("plugin") != null && customObj.get("plugin").getAsBoolean()) {
                Documentation doc = new Documentation();
                doc.setLongDescription(customObj.toString());
                type.setDocumentation(doc);
            }
            type.setProperties(properties);
            type.setKey(key);
            type.setName(id);
            if (changed) {
                type.setJpql(jpql);
            }
            JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
            mapping.setCanEdit(canEdit);
            mapping.setJPAType(((JPAEdmMappingImpl)mainType.getMapping()).getJPAType());
            mapping.setVirtualAccess(true);
            if (canEdit) {
                mapping.setInternalName(mainEntity);
            }
            type.setMapping((Mapping)mapping);
            this.addCalcFields(type, addFields, mainAlias, true);
            edmSchema.getEntityTypes().add(type);
            return set;
        }
        if (query instanceof ReadAllQuery) {
            entity = ((ReadAllQuery)query).getExpressionBuilder().getQueryClass().getSimpleName();
        }
        return this.createEntityDataSource(edmSchema, id, entity, addFields, customObj);
    }

    public EntitySet createSQLDataSource(Schema edmSchema, String id, String sql, String entity, List<CalcField> addFields, JsonObject customObj) {
        try {
            String edmNamespace = edmSchema.getNamespace();
            EntitySet set = new EntitySet();
            set.setName(id);
            set.setEntityType(new FullQualifiedName(edmNamespace, id));
            ((EntityContainer)edmSchema.getEntityContainers().get(0)).getEntitySets().add(set);
            Key key = new Key();
            LinkedList<PropertyRef> propertyRefList = new LinkedList<PropertyRef>();
            key.setKeys(propertyRefList);
            LinkedList<SimpleProperty> properties = new LinkedList<SimpleProperty>();
            LinkedList<Property> keys = new LinkedList<Property>();
            if (!this.em.getTransaction().isActive()) {
                this.em.getTransaction().begin();
            }
            Connection connection = (Connection)this.em.unwrap(Connection.class);
            List<String> inputs = JPQLParserUtil.parseParams((String)sql);
            for (String param : inputs) {
                sql = JPQLParserUtil.replaceToken((String)sql, ":" + param, "?");
            }
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (((Select)statement).getSelectBody() instanceof SetOperationList) {
                sql = "select * from (" + (String)sql + ") CRONAPP_ALIAS";
                statement = CCJSqlParserUtil.parse((String)sql);
            }
            HashSet<String> pks = new HashSet<String>();
            if (((Select)statement).getSelectBody() instanceof PlainSelect) {
                PlainSelect selectStatement = (PlainSelect)((Select)statement).getSelectBody();
                selectStatement.setWhere((net.sf.jsqlparser.expression.Expression)new NotEqualsTo((net.sf.jsqlparser.expression.Expression)new LongValue().withValue(1L), (net.sf.jsqlparser.expression.Expression)new LongValue().withValue(1L)));
                if (selectStatement.getFromItem() instanceof Table) {
                    Table table = (Table)selectStatement.getFromItem();
                    try (ResultSet columnsRs = connection.getMetaData().getPrimaryKeys(null, table.getSchemaName(), table.getName());){
                        while (columnsRs.next()) {
                            pks.add(columnsRs.getString("COLUMN_NAME"));
                        }
                    }
                }
            }
            try (Iterator ps = connection.prepareStatement(statement.toString());){
                int j;
                try {
                    int n = inputs.size() > 0 ? inputs.size() : ps.getParameterMetaData().getParameterCount();
                    for (int j2 = 1; j2 <= n; ++j2) {
                        ps.setNull(j2, 0);
                    }
                }
                catch (Throwable throwable) {
                    List<String> newInputs = JPQLParserUtil.parseParams(statement.toString());
                    for (j = 1; j <= newInputs.size(); ++j) {
                        ps.setNull(j, 0);
                    }
                }
                HashSet<String> hashSet = new HashSet<String>();
                try (ResultSet rs = ps.executeQuery();){
                    for (j = 1; j <= rs.getMetaData().getColumnCount(); ++j) {
                        Object name = rs.getMetaData().getColumnName(j);
                        if (StringUtils.isBlank((CharSequence)name)) {
                            name = "column";
                        }
                        if (((String)name).contains("(") && StringUtils.isBlank((CharSequence)(name = ((String)name).substring(0, ((String)name).indexOf("("))))) {
                            name = "expression";
                        }
                        if (!Functions.isValidIdentifier((String)name)) {
                            name = "expression";
                        }
                        int i = 1;
                        while (hashSet.contains(name)) {
                            name = rs.getMetaData().getColumnName(j) + "_" + ++i;
                        }
                        hashSet.add((String)name);
                        SimpleProperty property = new SimpleProperty();
                        property.setType(DatasourceExtension.toEdmSimpleTypeKind(Class.forName(rs.getMetaData().getColumnClassName(j))));
                        property.setName((String)name);
                        JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
                        mapping.setJPAType(Class.forName(rs.getMetaData().getColumnClassName(j)));
                        mapping.setVirtualAccess(true);
                        mapping.setIndex(Integer.valueOf(j));
                        property.setMapping((Mapping)mapping);
                        properties.add(property);
                    }
                }
            }
            for (Property property : properties) {
                if (pks.size() > 0) {
                    if (!pks.contains(property.getName())) continue;
                    keys.add(property);
                    continue;
                }
                keys.add(property);
            }
            if (keys.isEmpty()) {
                for (Property property : properties) {
                    keys.add(property);
                }
            }
            SimpleProperty objectKey = new SimpleProperty();
            objectKey.setName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            objectKey.setType(EdmSimpleTypeKind.String);
            JPAEdmMappingImpl jPAEdmMappingImpl = new JPAEdmMappingImpl();
            jPAEdmMappingImpl.setInternalName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            jPAEdmMappingImpl.setJPAType(EdmString.class);
            jPAEdmMappingImpl.setVirtualAccess(true);
            objectKey.setMapping((Mapping)jPAEdmMappingImpl);
            objectKey.setComposite(keys);
            PropertyRef propertyRef = new PropertyRef();
            propertyRef.setName(ODataJPAConfig.COMPOSITE_KEY_NAME);
            propertyRefList.add(propertyRef);
            properties.add(objectKey);
            EntityType type = new EntityType();
            type.setProperties(properties);
            type.setKey(key);
            type.setName(id);
            JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
            mapping.setVirtualAccess(true);
            type.setMapping((Mapping)mapping);
            edmSchema.getEntityTypes().add(type);
            return set;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private EntitySet createEntityDataSource(Schema edmSchema, String id, String entity, List<CalcField> addFields, JsonObject customObj) {
        String edmNamespace = edmSchema.getNamespace();
        Iterator iterator = edmSchema.getEntityContainers().iterator();
        if (iterator.hasNext()) {
            EntityContainer container = (EntityContainer)iterator.next();
            EntitySet foundES = null;
            for (EntitySet entitySet : container.getEntitySets()) {
                if (!entitySet.getEntityType().getName().equals(entity)) continue;
                foundES = entitySet;
                break;
            }
            EntityType oldType = edmSchema.getEntityType(entity);
            EntityType newType = (EntityType)CloneUtils.getClone((Object)oldType);
            newType.setShowMetadata(true);
            newType.setName(id);
            if (customObj != null && customObj.get("plugin") != null && customObj.get("plugin").getAsBoolean()) {
                Documentation doc = new Documentation();
                doc.setLongDescription(customObj.toString());
                newType.setDocumentation(doc);
            }
            this.addDisplayFields(edmSchema, newType);
            this.addCalcFields(newType, addFields, "u", false);
            edmSchema.getEntityTypes().add(newType);
            EntitySet set = new EntitySet();
            set.setName(id);
            set.setEntityType(new FullQualifiedName(edmNamespace, id));
            set.setMapping(foundES.getMapping());
            set.setAnnotationAttributes(foundES.getAnnotationAttributes());
            set.setAnnotationElements(foundES.getAnnotationElements());
            container.getEntitySets().add(set);
            LinkedList<DSAssociationSet> addAssociationSet = new LinkedList<DSAssociationSet>();
            for (AssociationSet associationSet : container.getAssociationSets()) {
                if (associationSet instanceof DSAssociationSet || !associationSet.getEnd1().getRole().equals(entity)) continue;
                DSAssociationSet newAssociation = new DSAssociationSet();
                newAssociation.setName(associationSet.getName() + "_" + id);
                newAssociation.setAnnotationAttributes(associationSet.getAnnotationAttributes());
                newAssociation.setAnnotationElements(associationSet.getAnnotationElements());
                newAssociation.setAssociation(associationSet.getAssociation());
                AssociationSetEnd end = new AssociationSetEnd();
                end.setEntitySet(id);
                end.setRole(associationSet.getEnd1().getRole());
                newAssociation.setEnd1(end);
                newAssociation.setEnd2(associationSet.getEnd2());
                addAssociationSet.add(newAssociation);
            }
            for (AssociationSet associationSet : addAssociationSet) {
                container.getAssociationSets().add(associationSet);
            }
            return set;
        }
        return null;
    }

    public InputStream getJPAEdmMappingModelStream() {
        return null;
    }

    static {
        GRID_PREFERED_FIELDS.add("(.*?name.*?|.*?nome.*?|.*?title.*?|.*?titulo.*?|.*?firstname.*?|.*?primeironome.*?|.*?description.*?|.*?descricao.*?|.*?jobtitle.*?|^cpf$|^rg$)");
        PLAIN_EXPRESSION = Pattern.compile("^[a-zA-Z0-9_.-]*$");
    }

    public static class DSAssociationSet
    extends AssociationSet {
    }

    public static class CalcField {
        String name = null;
        String expression = null;
        String type = null;
    }
}

