/*
 * Decompiled with CFR 0.152.
 */
package io.drdroid.api.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.drdroid.api.IDrDroidAPI;
import io.drdroid.api.models.ClientConfig;
import io.drdroid.api.models.Workflow;
import io.drdroid.api.models.WorkflowEvent;
import io.drdroid.api.models.http.request.Data;
import io.drdroid.api.models.http.request.UUIDRegister;
import io.drdroid.api.producer.HTTPProducer;
import io.drdroid.api.producer.IProducer;
import io.drdroid.api.utils.DateTimeFormatter;
import io.drdroid.api.utils.WorkflowEventDecorator;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncClient
implements IDrDroidAPI {
    private static final int MAX_THREADS = 40;
    private static final int MIN_THREADS = 1;
    private static final UUID uuid = UUID.randomUUID();
    private Boolean registered = false;
    private final int eventLimit;
    private final int batchSize;
    private final int maxWaitTimeInMs;
    private final AtomicLong droppedCount = new AtomicLong(0L);
    private final AtomicLong eventId = new AtomicLong(0L);
    private final BlockingQueue<WorkflowEvent> events = new LinkedBlockingQueue<WorkflowEvent>();
    private final Lock registerLock = new ReentrantLock();
    private final WorkflowEventDecorator workflowEventDecorator;
    private final IProducer producer;
    private final ClientConfig clientConfig;

    public AsyncClient(ClientConfig config) {
        this.clientConfig = config;
        this.eventLimit = config.getMaxQueueSize();
        this.maxWaitTimeInMs = config.getAsyncMaxWaitTimeInMs();
        this.batchSize = config.getAsyncBatchSize();
        this.workflowEventDecorator = new WorkflowEventDecorator(config.getServiceName());
        this.producer = new HTTPProducer(this.clientConfig);
        this.createQueuePoller();
    }

    @Override
    public long getSentEventCount() {
        return this.eventId.get();
    }

    @Override
    public long getLostEventCount() {
        return this.droppedCount.get();
    }

    @Override
    public int getNumOfPendingEvents() {
        return this.events.size();
    }

    @Override
    public void send(String workflowName, String state, Map<String, Object> payload) {
        String timestamp = DateTimeFormatter.getCurrentFormattedTimeStamp();
        Workflow workflow = new Workflow(workflowName);
        WorkflowEvent event = new WorkflowEvent(workflow, timestamp, state, payload);
        if (this.events.size() > this.eventLimit) {
            this.droppedCount.incrementAndGet();
        } else {
            this.events.add(event);
        }
    }

    private void createQueuePoller() {
        float messageSentPerSecondInSingleThread;
        int qps = this.clientConfig.getMessagePerSecond();
        int threadsRequied = qps / (int)(messageSentPerSecondInSingleThread = (float)(1000 * this.batchSize / this.clientConfig.getSocketTimeoutInMs()));
        if (threadsRequied > 40) {
            threadsRequied = 40;
        } else if (threadsRequied < 1) {
            threadsRequied = 1;
        }
        ExecutorService poller = Executors.newFixedThreadPool(threadsRequied, new ThreadFactoryBuilder().setNameFormat("AsyncDrDroidClientPoller-%d").build());
        for (int i = 0; i < threadsRequied; ++i) {
            poller.execute(this.createPoller());
        }
    }

    private Runnable createPoller() {
        return () -> {
            while (true) {
                try {
                    while (true) {
                        ArrayList eventSet = new ArrayList();
                        this.events.drainTo(eventSet, this.batchSize);
                        if (!this.registered.booleanValue()) {
                            this.register();
                        }
                        if (eventSet.size() > 0) {
                            ArrayList<WorkflowEvent> workflowEventSet = new ArrayList<WorkflowEvent>(eventSet.size());
                            Iterator var5 = eventSet.iterator();
                            while (true) {
                                if (!var5.hasNext()) {
                                    this.producer.sendBatch(new Data(workflowEventSet));
                                    break;
                                }
                                WorkflowEvent event = (WorkflowEvent)var5.next();
                                long eventNum = this.eventId.incrementAndGet();
                                workflowEventSet.add(this.workflowEventDecorator.build(event, eventNum, uuid.toString()));
                            }
                        }
                        if (this.events.size() >= this.eventLimit) continue;
                        Thread.sleep(this.maxWaitTimeInMs);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        };
    }

    @VisibleForTesting
    protected void register() {
        HashMap<String, String> resourceKvs = new HashMap<String, String>();
        resourceKvs.put("Port", String.valueOf(this.clientConfig.getServicePort()));
        if (this.registerLock.tryLock()) {
            try {
                UUIDRegister register = new UUIDRegister();
                register.setServiceName(this.clientConfig.getServiceName());
                register.setUuid(uuid);
                register.setResourceKvs(resourceKvs);
                register.setIp(InetAddress.getLocalHost().getHostAddress());
                this.registered = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

