/*
 * Decompiled with CFR 0.152.
 */
package io.drdroid.api.producer;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import io.drdroid.api.models.ClientConfig;
import io.drdroid.api.models.http.request.Data;
import io.drdroid.api.models.http.request.RequestPayload;
import io.drdroid.api.models.http.request.UUIDRegister;
import io.drdroid.api.models.http.response.RegisterAPIResponse;
import io.drdroid.api.models.http.response.SendBatchAPIResponse;
import io.drdroid.api.producer.IProducer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import retrofit.Call;
import retrofit.Converter;
import retrofit.JacksonConverterFactory;
import retrofit.Response;
import retrofit.Retrofit;
import retrofit.http.Body;
import retrofit.http.POST;

public class HTTPProducer
implements IProducer {
    private final MessageProducer producer;

    public HTTPProducer(ClientConfig config) {
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setConnectTimeout((long)config.getConnectionTimeoutInMs(), TimeUnit.MILLISECONDS);
        okHttpClient.setReadTimeout((long)config.getSocketTimeoutInMs(), TimeUnit.MILLISECONDS);
        okHttpClient.interceptors().add(chain -> {
            Request request = chain.request().newBuilder().addHeader("Content-Type", "application/json").addHeader("X-REQUEST-ORG", config.getOrg()).build();
            return chain.proceed(request);
        });
        Retrofit retrofit = new Retrofit.Builder().baseUrl(config.getSinkUrl()).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.producer = (MessageProducer)retrofit.create(MessageProducer.class);
    }

    @Override
    public Integer sendBatch(Data data) {
        Call<SendBatchAPIResponse> call = this.producer.send(new RequestPayload(data));
        try {
            Response response = call.execute();
            return ((SendBatchAPIResponse)response.body()).getCount();
        }
        catch (IOException var4) {
            var4.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean register(UUIDRegister register) {
        Call<RegisterAPIResponse> call = this.producer.register(register);
        try {
            call.execute();
            return true;
        }
        catch (IOException var4) {
            var4.printStackTrace();
            return false;
        }
    }

    @Override
    public void sendBeat(UUIDRegister register) {
    }

    protected static interface MessageProducer {
        @POST(value="w/agent/push_events")
        public Call<SendBatchAPIResponse> send(@Body RequestPayload var1);

        @POST(value="w/agent/register")
        public Call<RegisterAPIResponse> register(@Body UUIDRegister var1);

        @POST(value="w/agent/register")
        public Call<RegisterAPIResponse> sendBeat(@Body UUIDRegister var1);
    }
}

