/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="EC10")
public class AvoidUnoptimizedVectorImagesCheck
extends PythonSubscriptionCheck {
    public static final String DESCRIPTION = "Avoid using unoptimized vector images";
    private static final Pattern LAYERS_PATTERN = Pattern.compile("</g>");

    public void initialize(SubscriptionCheck.Context ctx) {
        ctx.registerSyntaxNodeConsumer(Tree.Kind.STRING_ELEMENT, this::checkSVG);
    }

    private void checkSVG(SubscriptionContext ctx) {
        StringElement stringLiteral = (StringElement)ctx.syntaxNode();
        this.checkComments(stringLiteral, ctx);
        this.checkLayers(stringLiteral, ctx);
        this.checkNamespaces(stringLiteral, ctx);
        this.checkMetadata(stringLiteral, ctx);
    }

    private void checkComments(StringElement str, SubscriptionContext ctx) {
        if (this.isSvgTagNotDetected(str)) {
            return;
        }
        if (str.value().contains("<!--") || str.value().contains("-->")) {
            ctx.addIssue((Tree)str, DESCRIPTION);
        }
    }

    private void checkLayers(StringElement str, SubscriptionContext ctx) {
        if (this.isSvgTagNotDetected(str)) {
            return;
        }
        Matcher matcher = LAYERS_PATTERN.matcher(str.value());
        int matches = 0;
        while (matcher.find()) {
            ++matches;
        }
        if (matches > 1) {
            ctx.addIssue((Tree)str, DESCRIPTION);
        }
    }

    private void checkNamespaces(StringElement str, SubscriptionContext ctx) {
        if (this.isSvgTagNotDetected(str)) {
            return;
        }
        if (str.value().contains("xmlns:") && !str.value().contains("xmlns:svg=")) {
            ctx.addIssue((Tree)str, DESCRIPTION);
        }
    }

    private void checkMetadata(StringElement str, SubscriptionContext ctx) {
        if (this.isSvgTagNotDetected(str)) {
            return;
        }
        if (str.value().contains("</metadata>")) {
            ctx.addIssue((Tree)str, DESCRIPTION);
        }
    }

    private boolean isSvgTagNotDetected(StringElement str) {
        return !str.value().contains("</svg>");
    }
}

