/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import io.intercom.api.TypedData;
import io.intercom.api.TypedDataCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

class TypedDataCollectionIterator<T extends TypedData>
implements Iterator<T> {
    private TypedDataCollection<T> rollingCollection;
    private int pos;

    public TypedDataCollectionIterator(TypedDataCollection<T> startingCollection) {
        this.rollingCollection = startingCollection;
        this.pos = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.pos == this.rollingCollection.getPage().size()) {
            if (this.rollingCollection.hasNextPage()) {
                this.rollingCollection = this.rollingCollection.nextPage();
                this.pos = 0;
                return true;
            }
            return false;
        }
        return this.pos <= this.rollingCollection.getPage().size();
    }

    @Override
    public T next() {
        this.iterate();
        TypedData t = (TypedData)this.rollingCollection.getPage().get(this.pos);
        ++this.pos;
        return (T)t;
    }

    private void iterate() {
        if (this.pos == this.rollingCollection.getPage().size()) {
            if (this.rollingCollection.hasNextPage()) {
                this.rollingCollection = this.rollingCollection.nextPage();
                this.pos = 0;
            } else {
                throw new NoSuchElementException();
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

