/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.core;

import com.intercom.api.core.ApiVersion;
import com.intercom.api.core.Environment;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.RetryInterceptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class ClientOptions {
    private final Environment environment;
    private final Map<String, String> headers;
    private final Map<String, Supplier<String>> headerSuppliers;
    private final OkHttpClient httpClient;
    private final int timeout;
    private final ApiVersion version;

    private ClientOptions(Environment environment, Map<String, String> headers, Map<String, Supplier<String>> headerSuppliers, OkHttpClient httpClient, int timeout, Optional<ApiVersion> version) {
        this.environment = environment;
        this.headers = new HashMap<String, String>();
        this.headers.putAll(headers);
        this.headers.putAll((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("User-Agent", "io.intercom:intercom-java/3.0.0-alpha7");
                this.put("X-Fern-Language", "JAVA");
                this.put("X-Fern-SDK-Name", "com.intercom.fern:api-sdk");
                this.put("X-Fern-SDK-Version", "3.0.0-alpha7");
            }
        });
        this.headerSuppliers = headerSuppliers;
        this.httpClient = httpClient;
        this.timeout = timeout;
        this.version = version.orElse(ApiVersion._2_11);
        this.headers.put("Intercom-Version", this.version.toString());
    }

    public Environment environment() {
        return this.environment;
    }

    public Map<String, String> headers(RequestOptions requestOptions) {
        HashMap<String, String> values = new HashMap<String, String>(this.headers);
        this.headerSuppliers.forEach((key, supplier) -> values.put((String)key, (String)supplier.get()));
        if (requestOptions != null) {
            values.putAll(requestOptions.getHeaders());
        }
        return values;
    }

    public ApiVersion version() {
        return this.version;
    }

    public int timeout(RequestOptions requestOptions) {
        if (requestOptions == null) {
            return this.timeout;
        }
        return requestOptions.getTimeout().orElse(this.timeout);
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public OkHttpClient httpClientWithTimeout(RequestOptions requestOptions) {
        if (requestOptions == null) {
            return this.httpClient;
        }
        return this.httpClient.newBuilder().callTimeout((long)requestOptions.getTimeout().get().intValue(), requestOptions.getTimeoutTimeUnit()).connectTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Environment environment;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, Supplier<String>> headerSuppliers = new HashMap<String, Supplier<String>>();
        private int maxRetries = 2;
        private Optional<Integer> timeout = Optional.empty();
        private OkHttpClient httpClient = null;
        private Optional<ApiVersion> version = Optional.empty();

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeader(String key, Supplier<String> value) {
            this.headerSuppliers.put(key, value);
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = Optional.of(timeout);
            return this;
        }

        public Builder timeout(Optional<Integer> timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder version(ApiVersion version) {
            this.version = Optional.of(version);
            return this;
        }

        public ClientOptions build() {
            OkHttpClient.Builder httpClientBuilder;
            OkHttpClient.Builder builder = httpClientBuilder = this.httpClient != null ? this.httpClient.newBuilder() : new OkHttpClient.Builder();
            if (this.httpClient != null) {
                this.timeout.ifPresent(timeout -> httpClientBuilder.callTimeout((long)timeout.intValue(), TimeUnit.SECONDS).connectTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS));
            } else {
                httpClientBuilder.callTimeout((long)this.timeout.orElse(60).intValue(), TimeUnit.SECONDS).connectTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).addInterceptor((Interceptor)new RetryInterceptor(this.maxRetries));
            }
            this.httpClient = httpClientBuilder.build();
            this.timeout = Optional.of(this.httpClient.callTimeoutMillis() / 1000);
            return new ClientOptions(this.environment, this.headers, this.headerSuppliers, this.httpClient, this.timeout.get(), this.version);
        }
    }
}

