/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConvertConversationToTicketRequest {
    private final String conversationId;
    private final String ticketTypeId;
    private final Optional<Map<String, Object>> attributes;
    private final Map<String, Object> additionalProperties;

    private ConvertConversationToTicketRequest(String conversationId, String ticketTypeId, Optional<Map<String, Object>> attributes, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.ticketTypeId = ticketTypeId;
        this.attributes = attributes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="ticket_type_id")
    public String getTicketTypeId() {
        return this.ticketTypeId;
    }

    @JsonProperty(value="attributes")
    public Optional<Map<String, Object>> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConvertConversationToTicketRequest && this.equalTo((ConvertConversationToTicketRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConvertConversationToTicketRequest other) {
        return this.conversationId.equals(other.conversationId) && this.ticketTypeId.equals(other.ticketTypeId) && this.attributes.equals(other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.ticketTypeId, this.attributes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConversationIdStage,
    TicketTypeIdStage,
    _FinalStage {
        private String conversationId;
        private String ticketTypeId;
        private Optional<Map<String, Object>> attributes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConvertConversationToTicketRequest other) {
            this.conversationId(other.getConversationId());
            this.ticketTypeId(other.getTicketTypeId());
            this.attributes(other.getAttributes());
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public TicketTypeIdStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type_id")
        public _FinalStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @Override
        public _FinalStage attributes(Map<String, Object> attributes) {
            this.attributes = Optional.ofNullable(attributes);
            return this;
        }

        @Override
        @JsonSetter(value="attributes", nulls=Nulls.SKIP)
        public _FinalStage attributes(Optional<Map<String, Object>> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public ConvertConversationToTicketRequest build() {
            return new ConvertConversationToTicketRequest(this.conversationId, this.ticketTypeId, this.attributes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConvertConversationToTicketRequest build();

        public _FinalStage attributes(Optional<Map<String, Object>> var1);

        public _FinalStage attributes(Map<String, Object> var1);
    }

    public static interface TicketTypeIdStage {
        public _FinalStage ticketTypeId(@NotNull String var1);
    }

    public static interface ConversationIdStage {
        public TicketTypeIdStage conversationId(@NotNull String var1);

        public Builder from(ConvertConversationToTicketRequest var1);
    }
}

