/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataexport.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataExport {
    private final String jobIdentifier;
    private final Status status;
    private final String downloadExpiresAt;
    private final String downloadUrl;
    private final Map<String, Object> additionalProperties;

    private DataExport(String jobIdentifier, Status status, String downloadExpiresAt, String downloadUrl, Map<String, Object> additionalProperties) {
        this.jobIdentifier = jobIdentifier;
        this.status = status;
        this.downloadExpiresAt = downloadExpiresAt;
        this.downloadUrl = downloadUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="job_identifier")
    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="download_expires_at")
    public String getDownloadExpiresAt() {
        return this.downloadExpiresAt;
    }

    @JsonProperty(value="download_url")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataExport && this.equalTo((DataExport)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataExport other) {
        return this.jobIdentifier.equals(other.jobIdentifier) && this.status.equals(other.status) && this.downloadExpiresAt.equals(other.downloadExpiresAt) && this.downloadUrl.equals(other.downloadUrl);
    }

    public int hashCode() {
        return Objects.hash(this.jobIdentifier, this.status, this.downloadExpiresAt, this.downloadUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobIdentifierStage builder() {
        return new Builder();
    }

    public static final class Status {
        public static final Status FAILED = new Status(Value.FAILED, "failed");
        public static final Status COMPLETED = new Status(Value.COMPLETED, "completed");
        public static final Status NO_DATA = new Status(Value.NO_DATA, "no_data");
        public static final Status PENDING = new Status(Value.PENDING, "pending");
        public static final Status IN_PROGRESS = new Status(Value.IN_PROGRESS, "in_progress");
        public static final Status CANCELED = new Status(Value.CANCELED, "canceled");
        private final Value value;
        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Status && this.string.equals(((Status)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case FAILED: {
                    return visitor.visitFailed();
                }
                case COMPLETED: {
                    return visitor.visitCompleted();
                }
                case NO_DATA: {
                    return visitor.visitNoData();
                }
                case PENDING: {
                    return visitor.visitPending();
                }
                case IN_PROGRESS: {
                    return visitor.visitInProgress();
                }
                case CANCELED: {
                    return visitor.visitCanceled();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "failed": {
                    return FAILED;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "no_data": {
                    return NO_DATA;
                }
                case "pending": {
                    return PENDING;
                }
                case "in_progress": {
                    return IN_PROGRESS;
                }
                case "canceled": {
                    return CANCELED;
                }
            }
            return new Status(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPending();

            public T visitInProgress();

            public T visitFailed();

            public T visitCompleted();

            public T visitNoData();

            public T visitCanceled();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PENDING,
            IN_PROGRESS,
            FAILED,
            COMPLETED,
            NO_DATA,
            CANCELED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements JobIdentifierStage,
    StatusStage,
    DownloadExpiresAtStage,
    DownloadUrlStage,
    _FinalStage {
        private String jobIdentifier;
        private Status status;
        private String downloadExpiresAt;
        private String downloadUrl;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataExport other) {
            this.jobIdentifier(other.getJobIdentifier());
            this.status(other.getStatus());
            this.downloadExpiresAt(other.getDownloadExpiresAt());
            this.downloadUrl(other.getDownloadUrl());
            return this;
        }

        @Override
        @JsonSetter(value="job_identifier")
        public StatusStage jobIdentifier(@NotNull String jobIdentifier) {
            this.jobIdentifier = Objects.requireNonNull(jobIdentifier, "jobIdentifier must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public DownloadExpiresAtStage status(@NotNull Status status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="download_expires_at")
        public DownloadUrlStage downloadExpiresAt(@NotNull String downloadExpiresAt) {
            this.downloadExpiresAt = Objects.requireNonNull(downloadExpiresAt, "downloadExpiresAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="download_url")
        public _FinalStage downloadUrl(@NotNull String downloadUrl) {
            this.downloadUrl = Objects.requireNonNull(downloadUrl, "downloadUrl must not be null");
            return this;
        }

        @Override
        public DataExport build() {
            return new DataExport(this.jobIdentifier, this.status, this.downloadExpiresAt, this.downloadUrl, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataExport build();
    }

    public static interface DownloadUrlStage {
        public _FinalStage downloadUrl(@NotNull String var1);
    }

    public static interface DownloadExpiresAtStage {
        public DownloadUrlStage downloadExpiresAt(@NotNull String var1);
    }

    public static interface StatusStage {
        public DownloadExpiresAtStage status(@NotNull Status var1);
    }

    public static interface JobIdentifierStage {
        public StatusStage jobIdentifier(@NotNull String var1);

        public Builder from(DataExport var1);
    }
}

