/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickettypes.attributes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.tickettypes.attributes.AsyncRawAttributesClient;
import com.intercom.api.resources.tickettypes.attributes.requests.CreateTicketTypeAttributeRequest;
import com.intercom.api.resources.tickettypes.attributes.requests.UpdateTicketTypeAttributeRequest;
import com.intercom.api.types.TicketTypeAttribute;
import java.util.concurrent.CompletableFuture;

public class AsyncAttributesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawAttributesClient rawClient;

    public AsyncAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAttributesClient(clientOptions);
    }

    public AsyncRawAttributesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TicketTypeAttribute> create(CreateTicketTypeAttributeRequest request) {
        return this.rawClient.create(request).thenApply(response -> (TicketTypeAttribute)response.body());
    }

    public CompletableFuture<TicketTypeAttribute> create(CreateTicketTypeAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (TicketTypeAttribute)response.body());
    }

    public CompletableFuture<TicketTypeAttribute> update(UpdateTicketTypeAttributeRequest request) {
        return this.rawClient.update(request).thenApply(response -> (TicketTypeAttribute)response.body());
    }

    public CompletableFuture<TicketTypeAttribute> update(UpdateTicketTypeAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (TicketTypeAttribute)response.body());
    }
}

