/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.visitors.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MergeVisitorToContactRequest {
    private final String type;
    private final User user;
    private final Visitor visitor;
    private final Map<String, Object> additionalProperties;

    private MergeVisitorToContactRequest(String type, User user, Visitor visitor, Map<String, Object> additionalProperties) {
        this.type = type;
        this.user = user;
        this.visitor = visitor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    @JsonProperty(value="visitor")
    public Visitor getVisitor() {
        return this.visitor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MergeVisitorToContactRequest && this.equalTo((MergeVisitorToContactRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MergeVisitorToContactRequest other) {
        return this.type.equals(other.type) && this.user.equals(other.user) && this.visitor.equals(other.visitor);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.user, this.visitor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class Visitor {
        private final Object value;
        private final int type;

        private Visitor(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor_<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((VisitorWithId)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((VisitorWithUserId)this.value);
            }
            if (this.type == 2) {
                return visitor.visit((VisitorWithEmail)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Visitor && this.equalTo((Visitor)other);
        }

        private boolean equalTo(Visitor other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static Visitor of(VisitorWithId value) {
            return new Visitor(value, 0);
        }

        public static Visitor of(VisitorWithUserId value) {
            return new Visitor(value, 1);
        }

        public static Visitor of(VisitorWithEmail value) {
            return new Visitor(value, 2);
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class VisitorWithUserId {
            private final String userId;
            private final Map<String, Object> additionalProperties;

            private VisitorWithUserId(String userId, Map<String, Object> additionalProperties) {
                this.userId = userId;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="user_id")
            public String getUserId() {
                return this.userId;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof VisitorWithUserId && this.equalTo((VisitorWithUserId)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(VisitorWithUserId other) {
                return this.userId.equals(other.userId);
            }

            public int hashCode() {
                return Objects.hash(this.userId);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static UserIdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements UserIdStage,
            _FinalStage {
                private String userId;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(VisitorWithUserId other) {
                    this.userId(other.getUserId());
                    return this;
                }

                @Override
                @JsonSetter(value="user_id")
                public _FinalStage userId(@NotNull String userId) {
                    this.userId = Objects.requireNonNull(userId, "userId must not be null");
                    return this;
                }

                @Override
                public VisitorWithUserId build() {
                    return new VisitorWithUserId(this.userId, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public VisitorWithUserId build();
            }

            public static interface UserIdStage {
                public _FinalStage userId(@NotNull String var1);

                public Builder from(VisitorWithUserId var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class VisitorWithId {
            private final String id;
            private final Map<String, Object> additionalProperties;

            private VisitorWithId(String id, Map<String, Object> additionalProperties) {
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="id")
            public String getId() {
                return this.id;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof VisitorWithId && this.equalTo((VisitorWithId)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(VisitorWithId other) {
                return this.id.equals(other.id);
            }

            public int hashCode() {
                return Objects.hash(this.id);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements IdStage,
            _FinalStage {
                private String id;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(VisitorWithId other) {
                    this.id(other.getId());
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @Override
                public VisitorWithId build() {
                    return new VisitorWithId(this.id, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public VisitorWithId build();
            }

            public static interface IdStage {
                public _FinalStage id(@NotNull String var1);

                public Builder from(VisitorWithId var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class VisitorWithEmail {
            private final String email;
            private final Map<String, Object> additionalProperties;

            private VisitorWithEmail(String email, Map<String, Object> additionalProperties) {
                this.email = email;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="email")
            public String getEmail() {
                return this.email;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof VisitorWithEmail && this.equalTo((VisitorWithEmail)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(VisitorWithEmail other) {
                return this.email.equals(other.email);
            }

            public int hashCode() {
                return Objects.hash(this.email);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static EmailStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements EmailStage,
            _FinalStage {
                private String email;
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(VisitorWithEmail other) {
                    this.email(other.getEmail());
                    return this;
                }

                @Override
                @JsonSetter(value="email")
                public _FinalStage email(@NotNull String email) {
                    this.email = Objects.requireNonNull(email, "email must not be null");
                    return this;
                }

                @Override
                public VisitorWithEmail build() {
                    return new VisitorWithEmail(this.email, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public VisitorWithEmail build();
            }

            public static interface EmailStage {
                public _FinalStage email(@NotNull String var1);

                public Builder from(VisitorWithEmail var1);
            }
        }

        static final class Deserializer
        extends StdDeserializer<Visitor> {
            Deserializer() {
                super(Visitor.class);
            }

            public Visitor deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return Visitor.of((VisitorWithId)ObjectMappers.JSON_MAPPER.convertValue(value, VisitorWithId.class));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        return Visitor.of((VisitorWithUserId)ObjectMappers.JSON_MAPPER.convertValue(value, VisitorWithUserId.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        try {
                            return Visitor.of((VisitorWithEmail)ObjectMappers.JSON_MAPPER.convertValue(value, VisitorWithEmail.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException3) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }

        public static interface Visitor_<T> {
            public T visit(VisitorWithId var1);

            public T visit(VisitorWithUserId var1);

            public T visit(VisitorWithEmail var1);
        }
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class User {
        private final Object value;
        private final int type;

        private User(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((UserWithId)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((UserWithUserId)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof User && this.equalTo((User)other);
        }

        private boolean equalTo(User other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static User of(UserWithId value) {
            return new User(value, 0);
        }

        public static User of(UserWithUserId value) {
            return new User(value, 1);
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class UserWithUserId {
            private final String userId;
            private final Optional<String> email;
            private final Map<String, Object> additionalProperties;

            private UserWithUserId(String userId, Optional<String> email, Map<String, Object> additionalProperties) {
                this.userId = userId;
                this.email = email;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="user_id")
            public String getUserId() {
                return this.userId;
            }

            @JsonProperty(value="email")
            public Optional<String> getEmail() {
                return this.email;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof UserWithUserId && this.equalTo((UserWithUserId)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(UserWithUserId other) {
                return this.userId.equals(other.userId) && this.email.equals(other.email);
            }

            public int hashCode() {
                return Objects.hash(this.userId, this.email);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static UserIdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements UserIdStage,
            _FinalStage {
                private String userId;
                private Optional<String> email = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(UserWithUserId other) {
                    this.userId(other.getUserId());
                    this.email(other.getEmail());
                    return this;
                }

                @Override
                @JsonSetter(value="user_id")
                public _FinalStage userId(@NotNull String userId) {
                    this.userId = Objects.requireNonNull(userId, "userId must not be null");
                    return this;
                }

                @Override
                public _FinalStage email(String email) {
                    this.email = Optional.ofNullable(email);
                    return this;
                }

                @Override
                @JsonSetter(value="email", nulls=Nulls.SKIP)
                public _FinalStage email(Optional<String> email) {
                    this.email = email;
                    return this;
                }

                @Override
                public UserWithUserId build() {
                    return new UserWithUserId(this.userId, this.email, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public UserWithUserId build();

                public _FinalStage email(Optional<String> var1);

                public _FinalStage email(String var1);
            }

            public static interface UserIdStage {
                public _FinalStage userId(@NotNull String var1);

                public Builder from(UserWithUserId var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class UserWithId {
            private final String id;
            private final Optional<String> email;
            private final Map<String, Object> additionalProperties;

            private UserWithId(String id, Optional<String> email, Map<String, Object> additionalProperties) {
                this.id = id;
                this.email = email;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="id")
            public String getId() {
                return this.id;
            }

            @JsonProperty(value="email")
            public Optional<String> getEmail() {
                return this.email;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof UserWithId && this.equalTo((UserWithId)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(UserWithId other) {
                return this.id.equals(other.id) && this.email.equals(other.email);
            }

            public int hashCode() {
                return Objects.hash(this.id, this.email);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements IdStage,
            _FinalStage {
                private String id;
                private Optional<String> email = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(UserWithId other) {
                    this.id(other.getId());
                    this.email(other.getEmail());
                    return this;
                }

                @Override
                @JsonSetter(value="id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @Override
                public _FinalStage email(String email) {
                    this.email = Optional.ofNullable(email);
                    return this;
                }

                @Override
                @JsonSetter(value="email", nulls=Nulls.SKIP)
                public _FinalStage email(Optional<String> email) {
                    this.email = email;
                    return this;
                }

                @Override
                public UserWithId build() {
                    return new UserWithId(this.id, this.email, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public UserWithId build();

                public _FinalStage email(Optional<String> var1);

                public _FinalStage email(String var1);
            }

            public static interface IdStage {
                public _FinalStage id(@NotNull String var1);

                public Builder from(UserWithId var1);
            }
        }

        static final class Deserializer
        extends StdDeserializer<User> {
            Deserializer() {
                super(User.class);
            }

            public User deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return User.of((UserWithId)ObjectMappers.JSON_MAPPER.convertValue(value, UserWithId.class));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        return User.of((UserWithUserId)ObjectMappers.JSON_MAPPER.convertValue(value, UserWithUserId.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(UserWithId var1);

            public T visit(UserWithUserId var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    UserStage,
    VisitorStage,
    _FinalStage {
        private String type;
        private User user;
        private Visitor visitor;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MergeVisitorToContactRequest other) {
            this.type(other.getType());
            this.user(other.getUser());
            this.visitor(other.getVisitor());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public UserStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user")
        public VisitorStage user(@NotNull User user) {
            this.user = Objects.requireNonNull(user, "user must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="visitor")
        public _FinalStage visitor(@NotNull Visitor visitor) {
            this.visitor = Objects.requireNonNull(visitor, "visitor must not be null");
            return this;
        }

        @Override
        public MergeVisitorToContactRequest build() {
            return new MergeVisitorToContactRequest(this.type, this.user, this.visitor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MergeVisitorToContactRequest build();
    }

    public static interface VisitorStage {
        public _FinalStage visitor(@NotNull Visitor var1);
    }

    public static interface UserStage {
        public VisitorStage user(@NotNull User var1);
    }

    public static interface TypeStage {
        public UserStage type(@NotNull String var1);

        public Builder from(MergeVisitorToContactRequest var1);
    }
}

