/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.types.CursorPages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyScroll {
    private final List<Company> data;
    private final Optional<CursorPages> pages;
    private final Optional<Integer> totalCount;
    private final Optional<String> scrollParam;
    private final Map<String, Object> additionalProperties;

    private CompanyScroll(List<Company> data, Optional<CursorPages> pages, Optional<Integer> totalCount, Optional<String> scrollParam, Map<String, Object> additionalProperties) {
        this.data = data;
        this.pages = pages;
        this.totalCount = totalCount;
        this.scrollParam = scrollParam;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "list";
    }

    @JsonProperty(value="data")
    public List<Company> getData() {
        return this.data;
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="scroll_param")
    public Optional<String> getScrollParam() {
        return this.scrollParam;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyScroll && this.equalTo((CompanyScroll)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyScroll other) {
        return this.data.equals(other.data) && this.pages.equals(other.pages) && this.totalCount.equals(other.totalCount) && this.scrollParam.equals(other.scrollParam);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.pages, this.totalCount, this.scrollParam);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<Company> data = new ArrayList<Company>();
        private Optional<CursorPages> pages = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        private Optional<String> scrollParam = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CompanyScroll other) {
            this.data(other.getData());
            this.pages(other.getPages());
            this.totalCount(other.getTotalCount());
            this.scrollParam(other.getScrollParam());
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(List<Company> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        public Builder addData(Company data) {
            this.data.add(data);
            return this;
        }

        public Builder addAllData(List<Company> data) {
            this.data.addAll(data);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value="scroll_param", nulls=Nulls.SKIP)
        public Builder scrollParam(Optional<String> scrollParam) {
            this.scrollParam = scrollParam;
            return this;
        }

        public Builder scrollParam(String scrollParam) {
            this.scrollParam = Optional.ofNullable(scrollParam);
            return this;
        }

        public CompanyScroll build() {
            return new CompanyScroll(this.data, this.pages, this.totalCount, this.scrollParam, this.additionalProperties);
        }
    }
}

