/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContactReference;
import com.intercom.api.types.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationRating {
    private final int rating;
    private final String remark;
    private final int createdAt;
    private final ContactReference contact;
    private final Reference teammate;
    private final Map<String, Object> additionalProperties;

    private ConversationRating(int rating, String remark, int createdAt, ContactReference contact, Reference teammate, Map<String, Object> additionalProperties) {
        this.rating = rating;
        this.remark = remark;
        this.createdAt = createdAt;
        this.contact = contact;
        this.teammate = teammate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="rating")
    public int getRating() {
        return this.rating;
    }

    @JsonProperty(value="remark")
    public String getRemark() {
        return this.remark;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="contact")
    public ContactReference getContact() {
        return this.contact;
    }

    @JsonProperty(value="teammate")
    public Reference getTeammate() {
        return this.teammate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationRating && this.equalTo((ConversationRating)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationRating other) {
        return this.rating == other.rating && this.remark.equals(other.remark) && this.createdAt == other.createdAt && this.contact.equals(other.contact) && this.teammate.equals(other.teammate);
    }

    public int hashCode() {
        return Objects.hash(this.rating, this.remark, this.createdAt, this.contact, this.teammate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RatingStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RatingStage,
    RemarkStage,
    CreatedAtStage,
    ContactStage,
    TeammateStage,
    _FinalStage {
        private int rating;
        private String remark;
        private int createdAt;
        private ContactReference contact;
        private Reference teammate;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConversationRating other) {
            this.rating(other.getRating());
            this.remark(other.getRemark());
            this.createdAt(other.getCreatedAt());
            this.contact(other.getContact());
            this.teammate(other.getTeammate());
            return this;
        }

        @Override
        @JsonSetter(value="rating")
        public RemarkStage rating(int rating) {
            this.rating = rating;
            return this;
        }

        @Override
        @JsonSetter(value="remark")
        public CreatedAtStage remark(@NotNull String remark) {
            this.remark = Objects.requireNonNull(remark, "remark must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public ContactStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="contact")
        public TeammateStage contact(@NotNull ContactReference contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="teammate")
        public _FinalStage teammate(@NotNull Reference teammate) {
            this.teammate = Objects.requireNonNull(teammate, "teammate must not be null");
            return this;
        }

        @Override
        public ConversationRating build() {
            return new ConversationRating(this.rating, this.remark, this.createdAt, this.contact, this.teammate, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConversationRating build();
    }

    public static interface TeammateStage {
        public _FinalStage teammate(@NotNull Reference var1);
    }

    public static interface ContactStage {
        public TeammateStage contact(@NotNull ContactReference var1);
    }

    public static interface CreatedAtStage {
        public ContactStage createdAt(int var1);
    }

    public static interface RemarkStage {
        public CreatedAtStage remark(@NotNull String var1);
    }

    public static interface RatingStage {
        public RemarkStage rating(int var1);

        public Builder from(ConversationRating var1);
    }
}

