/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.DataEventSummaryItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataEventSummary {
    private final String email;
    private final String intercomUserId;
    private final String userId;
    private final List<DataEventSummaryItem> events;
    private final Map<String, Object> additionalProperties;

    private DataEventSummary(String email, String intercomUserId, String userId, List<DataEventSummaryItem> events, Map<String, Object> additionalProperties) {
        this.email = email;
        this.intercomUserId = intercomUserId;
        this.userId = userId;
        this.events = events;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "event.summary";
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="intercom_user_id")
    public String getIntercomUserId() {
        return this.intercomUserId;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="events")
    public List<DataEventSummaryItem> getEvents() {
        return this.events;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataEventSummary && this.equalTo((DataEventSummary)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventSummary other) {
        return this.email.equals(other.email) && this.intercomUserId.equals(other.intercomUserId) && this.userId.equals(other.userId) && this.events.equals(other.events);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.intercomUserId, this.userId, this.events);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EmailStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EmailStage,
    IntercomUserIdStage,
    UserIdStage,
    _FinalStage {
        private String email;
        private String intercomUserId;
        private String userId;
        private List<DataEventSummaryItem> events = new ArrayList<DataEventSummaryItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataEventSummary other) {
            this.email(other.getEmail());
            this.intercomUserId(other.getIntercomUserId());
            this.userId(other.getUserId());
            this.events(other.getEvents());
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public IntercomUserIdStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="intercom_user_id")
        public UserIdStage intercomUserId(@NotNull String intercomUserId) {
            this.intercomUserId = Objects.requireNonNull(intercomUserId, "intercomUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllEvents(List<DataEventSummaryItem> events) {
            this.events.addAll(events);
            return this;
        }

        @Override
        public _FinalStage addEvents(DataEventSummaryItem events) {
            this.events.add(events);
            return this;
        }

        @Override
        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public _FinalStage events(List<DataEventSummaryItem> events) {
            this.events.clear();
            this.events.addAll(events);
            return this;
        }

        @Override
        public DataEventSummary build() {
            return new DataEventSummary(this.email, this.intercomUserId, this.userId, this.events, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataEventSummary build();

        public _FinalStage events(List<DataEventSummaryItem> var1);

        public _FinalStage addEvents(DataEventSummaryItem var1);

        public _FinalStage addAllEvents(List<DataEventSummaryItem> var1);
    }

    public static interface UserIdStage {
        public _FinalStage userId(@NotNull String var1);
    }

    public static interface IntercomUserIdStage {
        public UserIdStage intercomUserId(@NotNull String var1);
    }

    public static interface EmailStage {
        public IntercomUserIdStage email(@NotNull String var1);

        public Builder from(DataEventSummary var1);
    }
}

