/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataEventSummaryItem {
    private final String name;
    private final String first;
    private final String last;
    private final int count;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private DataEventSummaryItem(String name, String first, String last, int count, Optional<String> description, Map<String, Object> additionalProperties) {
        this.name = name;
        this.first = first;
        this.last = last;
        this.count = count;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="first")
    public String getFirst() {
        return this.first;
    }

    @JsonProperty(value="last")
    public String getLast() {
        return this.last;
    }

    @JsonProperty(value="count")
    public int getCount() {
        return this.count;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataEventSummaryItem && this.equalTo((DataEventSummaryItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventSummaryItem other) {
        return this.name.equals(other.name) && this.first.equals(other.first) && this.last.equals(other.last) && this.count == other.count && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.first, this.last, this.count, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    FirstStage,
    LastStage,
    CountStage,
    _FinalStage {
        private String name;
        private String first;
        private String last;
        private int count;
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataEventSummaryItem other) {
            this.name(other.getName());
            this.first(other.getFirst());
            this.last(other.getLast());
            this.count(other.getCount());
            this.description(other.getDescription());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public FirstStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="first")
        public LastStage first(@NotNull String first) {
            this.first = Objects.requireNonNull(first, "first must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="last")
        public CountStage last(@NotNull String last) {
            this.last = Objects.requireNonNull(last, "last must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="count")
        public _FinalStage count(int count) {
            this.count = count;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public DataEventSummaryItem build() {
            return new DataEventSummaryItem(this.name, this.first, this.last, this.count, this.description, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataEventSummaryItem build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);
    }

    public static interface CountStage {
        public _FinalStage count(int var1);
    }

    public static interface LastStage {
        public CountStage last(@NotNull String var1);
    }

    public static interface FirstStage {
        public LastStage first(@NotNull String var1);
    }

    public static interface NameStage {
        public FirstStage name(@NotNull String var1);

        public Builder from(DataEventSummaryItem var1);
    }
}

