/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeletedArticleObject {
    private final String id;
    private final boolean deleted;
    private final Map<String, Object> additionalProperties;

    private DeletedArticleObject(String id, boolean deleted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.deleted = deleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="object")
    public String getObject() {
        return "article";
    }

    @JsonProperty(value="deleted")
    public boolean getDeleted() {
        return this.deleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeletedArticleObject && this.equalTo((DeletedArticleObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeletedArticleObject other) {
        return this.id.equals(other.id) && this.deleted == other.deleted;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.deleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    DeletedStage,
    _FinalStage {
        private String id;
        private boolean deleted;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeletedArticleObject other) {
            this.id(other.getId());
            this.deleted(other.getDeleted());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public DeletedStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="deleted")
        public _FinalStage deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Override
        public DeletedArticleObject build() {
            return new DeletedArticleObject(this.id, this.deleted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeletedArticleObject build();
    }

    public static interface DeletedStage {
        public _FinalStage deleted(boolean var1);
    }

    public static interface IdStage {
        public DeletedStage id(@NotNull String var1);

        public Builder from(DeletedArticleObject var1);
    }
}

