/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.UrlActionComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ImageComponent {
    private final Optional<String> id;
    private final String url;
    private final Optional<Align> align;
    private final int width;
    private final int height;
    private final Optional<Boolean> rounded;
    private final Optional<String> bottomMargin;
    private final Optional<UrlActionComponent> action;
    private final Map<String, Object> additionalProperties;

    private ImageComponent(Optional<String> id, String url, Optional<Align> align, int width, int height, Optional<Boolean> rounded, Optional<String> bottomMargin, Optional<UrlActionComponent> action, Map<String, Object> additionalProperties) {
        this.id = id;
        this.url = url;
        this.align = align;
        this.width = width;
        this.height = height;
        this.rounded = rounded;
        this.bottomMargin = bottomMargin;
        this.action = action;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="align")
    public Optional<Align> getAlign() {
        return this.align;
    }

    @JsonProperty(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonProperty(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonProperty(value="rounded")
    public Optional<Boolean> getRounded() {
        return this.rounded;
    }

    @JsonProperty(value="bottom_margin")
    public Optional<String> getBottomMargin() {
        return this.bottomMargin;
    }

    @JsonProperty(value="action")
    public Optional<UrlActionComponent> getAction() {
        return this.action;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImageComponent && this.equalTo((ImageComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImageComponent other) {
        return this.id.equals(other.id) && this.url.equals(other.url) && this.align.equals(other.align) && this.width == other.width && this.height == other.height && this.rounded.equals(other.rounded) && this.bottomMargin.equals(other.bottomMargin) && this.action.equals(other.action);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.align, this.width, this.height, this.rounded, this.bottomMargin, this.action);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    public static final class Align {
        public static final Align LEFT = new Align(Value.LEFT, "left");
        public static final Align RIGHT = new Align(Value.RIGHT, "right");
        public static final Align CENTER = new Align(Value.CENTER, "center");
        public static final Align FULL_WIDTH = new Align(Value.FULL_WIDTH, "full_width");
        private final Value value;
        private final String string;

        Align(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Align && this.string.equals(((Align)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case LEFT: {
                    return visitor.visitLeft();
                }
                case RIGHT: {
                    return visitor.visitRight();
                }
                case CENTER: {
                    return visitor.visitCenter();
                }
                case FULL_WIDTH: {
                    return visitor.visitFullWidth();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Align valueOf(String value) {
            switch (value) {
                case "left": {
                    return LEFT;
                }
                case "right": {
                    return RIGHT;
                }
                case "center": {
                    return CENTER;
                }
                case "full_width": {
                    return FULL_WIDTH;
                }
            }
            return new Align(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitLeft();

            public T visitCenter();

            public T visitRight();

            public T visitFullWidth();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            LEFT,
            CENTER,
            RIGHT,
            FULL_WIDTH,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UrlStage,
    WidthStage,
    HeightStage,
    _FinalStage {
        private String url;
        private int width;
        private int height;
        private Optional<UrlActionComponent> action = Optional.empty();
        private Optional<String> bottomMargin = Optional.empty();
        private Optional<Boolean> rounded = Optional.empty();
        private Optional<Align> align = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ImageComponent other) {
            this.id(other.getId());
            this.url(other.getUrl());
            this.align(other.getAlign());
            this.width(other.getWidth());
            this.height(other.getHeight());
            this.rounded(other.getRounded());
            this.bottomMargin(other.getBottomMargin());
            this.action(other.getAction());
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public WidthStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="width")
        public HeightStage width(int width) {
            this.width = width;
            return this;
        }

        @Override
        @JsonSetter(value="height")
        public _FinalStage height(int height) {
            this.height = height;
            return this;
        }

        @Override
        public _FinalStage action(UrlActionComponent action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @Override
        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public _FinalStage action(Optional<UrlActionComponent> action) {
            this.action = action;
            return this;
        }

        @Override
        public _FinalStage bottomMargin(String bottomMargin) {
            this.bottomMargin = Optional.ofNullable(bottomMargin);
            return this;
        }

        @Override
        @JsonSetter(value="bottom_margin", nulls=Nulls.SKIP)
        public _FinalStage bottomMargin(Optional<String> bottomMargin) {
            this.bottomMargin = bottomMargin;
            return this;
        }

        @Override
        public _FinalStage rounded(Boolean rounded) {
            this.rounded = Optional.ofNullable(rounded);
            return this;
        }

        @Override
        @JsonSetter(value="rounded", nulls=Nulls.SKIP)
        public _FinalStage rounded(Optional<Boolean> rounded) {
            this.rounded = rounded;
            return this;
        }

        @Override
        public _FinalStage align(Align align) {
            this.align = Optional.ofNullable(align);
            return this;
        }

        @Override
        @JsonSetter(value="align", nulls=Nulls.SKIP)
        public _FinalStage align(Optional<Align> align) {
            this.align = align;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public ImageComponent build() {
            return new ImageComponent(this.id, this.url, this.align, this.width, this.height, this.rounded, this.bottomMargin, this.action, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ImageComponent build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage align(Optional<Align> var1);

        public _FinalStage align(Align var1);

        public _FinalStage rounded(Optional<Boolean> var1);

        public _FinalStage rounded(Boolean var1);

        public _FinalStage bottomMargin(Optional<String> var1);

        public _FinalStage bottomMargin(String var1);

        public _FinalStage action(Optional<UrlActionComponent> var1);

        public _FinalStage action(UrlActionComponent var1);
    }

    public static interface HeightStage {
        public _FinalStage height(int var1);
    }

    public static interface WidthStage {
        public HeightStage width(int var1);
    }

    public static interface UrlStage {
        public WidthStage url(@NotNull String var1);

        public Builder from(ImageComponent var1);
    }
}

