/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ListItemWithImage;
import com.intercom.api.types.ListItemWithoutImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListComponent {
    private final List<ItemsItem> items;
    private final Optional<Boolean> disabled;
    private final Map<String, Object> additionalProperties;

    private ListComponent(List<ItemsItem> items, Optional<Boolean> disabled, Map<String, Object> additionalProperties) {
        this.items = items;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="items")
    public List<ItemsItem> getItems() {
        return this.items;
    }

    @JsonProperty(value="disabled")
    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListComponent && this.equalTo((ListComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListComponent other) {
        return this.items.equals(other.items) && this.disabled.equals(other.disabled);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.disabled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class ItemsItem {
        private final Object value;
        private final int type;

        private ItemsItem(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((ListItemWithImage)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((ListItemWithoutImage)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ItemsItem && this.equalTo((ItemsItem)other);
        }

        private boolean equalTo(ItemsItem other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static ItemsItem of(ListItemWithImage value) {
            return new ItemsItem(value, 0);
        }

        public static ItemsItem of(ListItemWithoutImage value) {
            return new ItemsItem(value, 1);
        }

        static final class Deserializer
        extends StdDeserializer<ItemsItem> {
            Deserializer() {
                super(ItemsItem.class);
            }

            public ItemsItem deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return ItemsItem.of((ListItemWithImage)ObjectMappers.JSON_MAPPER.convertValue(value, ListItemWithImage.class));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        return ItemsItem.of((ListItemWithoutImage)ObjectMappers.JSON_MAPPER.convertValue(value, ListItemWithoutImage.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(ListItemWithImage var1);

            public T visit(ListItemWithoutImage var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<ItemsItem> items = new ArrayList<ItemsItem>();
        private Optional<Boolean> disabled = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListComponent other) {
            this.items(other.getItems());
            this.disabled(other.getDisabled());
            return this;
        }

        @JsonSetter(value="items", nulls=Nulls.SKIP)
        public Builder items(List<ItemsItem> items) {
            this.items.clear();
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(ItemsItem items) {
            this.items.add(items);
            return this;
        }

        public Builder addAllItems(List<ItemsItem> items) {
            this.items.addAll(items);
            return this;
        }

        @JsonSetter(value="disabled", nulls=Nulls.SKIP)
        public Builder disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        public ListComponent build() {
            return new ListComponent(this.items, this.disabled, this.additionalProperties);
        }
    }
}

