/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.MultipleFilterSearchRequest;
import com.intercom.api.types.SingleFilterSearchRequest;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class MultipleOrSingleFilterSearchRequest {
    private final Object value;
    private final int type;

    private MultipleOrSingleFilterSearchRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((MultipleFilterSearchRequest)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((SingleFilterSearchRequest)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MultipleOrSingleFilterSearchRequest && this.equalTo((MultipleOrSingleFilterSearchRequest)other);
    }

    private boolean equalTo(MultipleOrSingleFilterSearchRequest other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static MultipleOrSingleFilterSearchRequest of(MultipleFilterSearchRequest value) {
        return new MultipleOrSingleFilterSearchRequest(value, 0);
    }

    public static MultipleOrSingleFilterSearchRequest of(SingleFilterSearchRequest value) {
        return new MultipleOrSingleFilterSearchRequest(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<MultipleOrSingleFilterSearchRequest> {
        Deserializer() {
            super(MultipleOrSingleFilterSearchRequest.class);
        }

        public MultipleOrSingleFilterSearchRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return MultipleOrSingleFilterSearchRequest.of((MultipleFilterSearchRequest)ObjectMappers.JSON_MAPPER.convertValue(value, MultipleFilterSearchRequest.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return MultipleOrSingleFilterSearchRequest.of((SingleFilterSearchRequest)ObjectMappers.JSON_MAPPER.convertValue(value, SingleFilterSearchRequest.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(MultipleFilterSearchRequest var1);

        public T visit(SingleFilterSearchRequest var1);
    }
}

