/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.AdminReplyConversationRequest;
import com.intercom.api.types.ContactReplyConversationRequest;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class ReplyConversationRequest {
    private final Object value;
    private final int type;

    private ReplyConversationRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((ContactReplyConversationRequest)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((AdminReplyConversationRequest)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ReplyConversationRequest && this.equalTo((ReplyConversationRequest)other);
    }

    private boolean equalTo(ReplyConversationRequest other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static ReplyConversationRequest of(ContactReplyConversationRequest value) {
        return new ReplyConversationRequest(value, 0);
    }

    public static ReplyConversationRequest of(AdminReplyConversationRequest value) {
        return new ReplyConversationRequest(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<ReplyConversationRequest> {
        Deserializer() {
            super(ReplyConversationRequest.class);
        }

        public ReplyConversationRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return ReplyConversationRequest.of((ContactReplyConversationRequest)ObjectMappers.JSON_MAPPER.convertValue(value, ContactReplyConversationRequest.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return ReplyConversationRequest.of((AdminReplyConversationRequest)ObjectMappers.JSON_MAPPER.convertValue(value, AdminReplyConversationRequest.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(ContactReplyConversationRequest var1);

        public T visit(AdminReplyConversationRequest var1);
    }
}

