/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TextAreaComponent {
    private final String id;
    private final Optional<String> label;
    private final Optional<String> placeholder;
    private final Optional<String> value;
    private final Optional<Boolean> error;
    private final Optional<Boolean> disabled;
    private final Map<String, Object> additionalProperties;

    private TextAreaComponent(String id, Optional<String> label, Optional<String> placeholder, Optional<String> value, Optional<Boolean> error, Optional<Boolean> disabled, Map<String, Object> additionalProperties) {
        this.id = id;
        this.label = label;
        this.placeholder = placeholder;
        this.value = value;
        this.error = error;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="label")
    public Optional<String> getLabel() {
        return this.label;
    }

    @JsonProperty(value="placeholder")
    public Optional<String> getPlaceholder() {
        return this.placeholder;
    }

    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return this.value;
    }

    @JsonProperty(value="error")
    public Optional<Boolean> getError() {
        return this.error;
    }

    @JsonProperty(value="disabled")
    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TextAreaComponent && this.equalTo((TextAreaComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TextAreaComponent other) {
        return this.id.equals(other.id) && this.label.equals(other.label) && this.placeholder.equals(other.placeholder) && this.value.equals(other.value) && this.error.equals(other.error) && this.disabled.equals(other.disabled);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.label, this.placeholder, this.value, this.error, this.disabled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<Boolean> disabled = Optional.empty();
        private Optional<Boolean> error = Optional.empty();
        private Optional<String> value = Optional.empty();
        private Optional<String> placeholder = Optional.empty();
        private Optional<String> label = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TextAreaComponent other) {
            this.id(other.getId());
            this.label(other.getLabel());
            this.placeholder(other.getPlaceholder());
            this.value(other.getValue());
            this.error(other.getError());
            this.disabled(other.getDisabled());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        @Override
        @JsonSetter(value="disabled", nulls=Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public _FinalStage error(Boolean error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        @Override
        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public _FinalStage error(Optional<Boolean> error) {
            this.error = error;
            return this;
        }

        @Override
        public _FinalStage value(String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public _FinalStage value(Optional<String> value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage placeholder(String placeholder) {
            this.placeholder = Optional.ofNullable(placeholder);
            return this;
        }

        @Override
        @JsonSetter(value="placeholder", nulls=Nulls.SKIP)
        public _FinalStage placeholder(Optional<String> placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        @Override
        public _FinalStage label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        @Override
        @JsonSetter(value="label", nulls=Nulls.SKIP)
        public _FinalStage label(Optional<String> label) {
            this.label = label;
            return this;
        }

        @Override
        public TextAreaComponent build() {
            return new TextAreaComponent(this.id, this.label, this.placeholder, this.value, this.error, this.disabled, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TextAreaComponent build();

        public _FinalStage label(Optional<String> var1);

        public _FinalStage label(String var1);

        public _FinalStage placeholder(Optional<String> var1);

        public _FinalStage placeholder(String var1);

        public _FinalStage value(Optional<String> var1);

        public _FinalStage value(String var1);

        public _FinalStage error(Optional<Boolean> var1);

        public _FinalStage error(Boolean var1);

        public _FinalStage disabled(Optional<Boolean> var1);

        public _FinalStage disabled(Boolean var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(TextAreaComponent var1);
    }
}

