/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketPartAuthor {
    private final Type type;
    private final String id;
    private final Optional<String> name;
    private final String email;
    private final Map<String, Object> additionalProperties;

    private TicketPartAuthor(Type type, String id, Optional<String> name, String email, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketPartAuthor && this.equalTo((TicketPartAuthor)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketPartAuthor other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.email.equals(other.email);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type BOT = new Type(Value.BOT, "bot");
        public static final Type ADMIN = new Type(Value.ADMIN, "admin");
        public static final Type USER = new Type(Value.USER, "user");
        public static final Type TEAM = new Type(Value.TEAM, "team");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case BOT: {
                    return visitor.visitBot();
                }
                case ADMIN: {
                    return visitor.visitAdmin();
                }
                case USER: {
                    return visitor.visitUser();
                }
                case TEAM: {
                    return visitor.visitTeam();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "bot": {
                    return BOT;
                }
                case "admin": {
                    return ADMIN;
                }
                case "user": {
                    return USER;
                }
                case "team": {
                    return TEAM;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitAdmin();

            public T visitBot();

            public T visitTeam();

            public T visitUser();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ADMIN,
            BOT,
            TEAM,
            USER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    IdStage,
    EmailStage,
    _FinalStage {
        private Type type;
        private String id;
        private String email;
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TicketPartAuthor other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.email(other.getEmail());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public EmailStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public _FinalStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public TicketPartAuthor build() {
            return new TicketPartAuthor(this.type, this.id, this.name, this.email, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TicketPartAuthor build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);
    }

    public static interface EmailStage {
        public _FinalStage email(@NotNull String var1);
    }

    public static interface IdStage {
        public EmailStage id(@NotNull String var1);
    }

    public static interface TypeStage {
        public IdStage type(@NotNull Type var1);

        public Builder from(TicketPartAuthor var1);
    }
}

