/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.TicketType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketTypeList {
    private final List<TicketType> ticketTypes;
    private final Map<String, Object> additionalProperties;

    private TicketTypeList(List<TicketType> ticketTypes, Map<String, Object> additionalProperties) {
        this.ticketTypes = ticketTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "ticket_type_attributes.list";
    }

    @JsonProperty(value="ticket_types")
    public List<TicketType> getTicketTypes() {
        return this.ticketTypes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketTypeList && this.equalTo((TicketTypeList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketTypeList other) {
        return this.ticketTypes.equals(other.ticketTypes);
    }

    public int hashCode() {
        return Objects.hash(this.ticketTypes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<TicketType> ticketTypes = new ArrayList<TicketType>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TicketTypeList other) {
            this.ticketTypes(other.getTicketTypes());
            return this;
        }

        @JsonSetter(value="ticket_types", nulls=Nulls.SKIP)
        public Builder ticketTypes(List<TicketType> ticketTypes) {
            this.ticketTypes.clear();
            this.ticketTypes.addAll(ticketTypes);
            return this;
        }

        public Builder addTicketTypes(TicketType ticketTypes) {
            this.ticketTypes.add(ticketTypes);
            return this;
        }

        public Builder addAllTicketTypes(List<TicketType> ticketTypes) {
            this.ticketTypes.addAll(ticketTypes);
            return this;
        }

        public TicketTypeList build() {
            return new TicketTypeList(this.ticketTypes, this.additionalProperties);
        }
    }
}

