/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.contacts;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.resources.contacts.RawContactsClient;
import com.intercom.api.resources.contacts.requests.ArchiveContactRequest;
import com.intercom.api.resources.contacts.requests.AttachSubscriptionToContactRequest;
import com.intercom.api.resources.contacts.requests.DeleteContactRequest;
import com.intercom.api.resources.contacts.requests.DetachSubscriptionFromContactRequest;
import com.intercom.api.resources.contacts.requests.FindContactRequest;
import com.intercom.api.resources.contacts.requests.ListAttachedCompaniesRequest;
import com.intercom.api.resources.contacts.requests.ListAttachedSubscriptionsRequest;
import com.intercom.api.resources.contacts.requests.ListContactsRequest;
import com.intercom.api.resources.contacts.requests.ListSegmentsAttachedToContactRequest;
import com.intercom.api.resources.contacts.requests.ListTagsAttachedToContactRequest;
import com.intercom.api.resources.contacts.requests.MergeContactsRequest;
import com.intercom.api.resources.contacts.requests.UnarchiveContactRequest;
import com.intercom.api.resources.contacts.requests.UpdateContactRequest;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.resources.subscriptiontypes.types.SubscriptionType;
import com.intercom.api.types.ContactArchived;
import com.intercom.api.types.ContactDeleted;
import com.intercom.api.types.ContactSegments;
import com.intercom.api.types.ContactUnarchived;
import com.intercom.api.types.CreateContactRequest;
import com.intercom.api.types.SearchRequest;
import com.intercom.api.types.SubscriptionTypeList;
import com.intercom.api.types.TagList;

public class ContactsClient {
    protected final ClientOptions clientOptions;
    private final RawContactsClient rawClient;

    public ContactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawContactsClient(clientOptions);
    }

    public RawContactsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Company> listAttachedCompanies(ListAttachedCompaniesRequest request) {
        return this.rawClient.listAttachedCompanies(request).body();
    }

    public SyncPagingIterable<Company> listAttachedCompanies(ListAttachedCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedCompanies(request, requestOptions).body();
    }

    public ContactSegments listAttachedSegments(ListSegmentsAttachedToContactRequest request) {
        return this.rawClient.listAttachedSegments(request).body();
    }

    public ContactSegments listAttachedSegments(ListSegmentsAttachedToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSegments(request, requestOptions).body();
    }

    public SubscriptionTypeList listAttachedSubscriptions(ListAttachedSubscriptionsRequest request) {
        return this.rawClient.listAttachedSubscriptions(request).body();
    }

    public SubscriptionTypeList listAttachedSubscriptions(ListAttachedSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSubscriptions(request, requestOptions).body();
    }

    public SubscriptionType attachSubscription(AttachSubscriptionToContactRequest request) {
        return this.rawClient.attachSubscription(request).body();
    }

    public SubscriptionType attachSubscription(AttachSubscriptionToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachSubscription(request, requestOptions).body();
    }

    public SubscriptionType detachSubscription(DetachSubscriptionFromContactRequest request) {
        return this.rawClient.detachSubscription(request).body();
    }

    public SubscriptionType detachSubscription(DetachSubscriptionFromContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachSubscription(request, requestOptions).body();
    }

    public TagList listAttachedTags(ListTagsAttachedToContactRequest request) {
        return this.rawClient.listAttachedTags(request).body();
    }

    public TagList listAttachedTags(ListTagsAttachedToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedTags(request, requestOptions).body();
    }

    public Contact find(FindContactRequest request) {
        return this.rawClient.find(request).body();
    }

    public Contact find(FindContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public Contact update(UpdateContactRequest request) {
        return this.rawClient.update(request).body();
    }

    public Contact update(UpdateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public ContactDeleted delete(DeleteContactRequest request) {
        return this.rawClient.delete(request).body();
    }

    public ContactDeleted delete(DeleteContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }

    public Contact mergeLeadInUser(MergeContactsRequest request) {
        return this.rawClient.mergeLeadInUser(request).body();
    }

    public Contact mergeLeadInUser(MergeContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.mergeLeadInUser(request, requestOptions).body();
    }

    public SyncPagingIterable<Contact> search(SearchRequest request) {
        return this.rawClient.search(request).body();
    }

    public SyncPagingIterable<Contact> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }

    public SyncPagingIterable<Contact> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Contact> list(ListContactsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Contact> list(ListContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public Contact create(CreateContactRequest request) {
        return this.rawClient.create(request).body();
    }

    public Contact create(CreateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public ContactArchived archive(ArchiveContactRequest request) {
        return this.rawClient.archive(request).body();
    }

    public ContactArchived archive(ArchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.archive(request, requestOptions).body();
    }

    public ContactUnarchived unarchive(UnarchiveContactRequest request) {
        return this.rawClient.unarchive(request).body();
    }

    public ContactUnarchived unarchive(UnarchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.unarchive(request, requestOptions).body();
    }
}

