/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.contacts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContactCompanies;
import com.intercom.api.types.ContactLocation;
import com.intercom.api.types.ContactNotes;
import com.intercom.api.types.ContactSocialProfiles;
import com.intercom.api.types.ContactTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Contact {
    private final Optional<String> type;
    private final String id;
    private final Optional<String> externalId;
    private final String workspaceId;
    private final String role;
    private final Optional<String> email;
    private final Optional<String> emailDomain;
    private final Optional<String> phone;
    private final Optional<String> formattedPhone;
    private final Optional<String> name;
    private final Optional<Integer> ownerId;
    private final boolean hasHardBounced;
    private final boolean markedEmailAsSpam;
    private final boolean unsubscribedFromEmails;
    private final int createdAt;
    private final int updatedAt;
    private final Optional<Integer> signedUpAt;
    private final Optional<Integer> lastSeenAt;
    private final Optional<Integer> lastRepliedAt;
    private final Optional<Integer> lastContactedAt;
    private final Optional<Integer> lastEmailOpenedAt;
    private final Optional<Integer> lastEmailClickedAt;
    private final Optional<String> languageOverride;
    private final Optional<String> browser;
    private final Optional<String> browserVersion;
    private final Optional<String> browserLanguage;
    private final Optional<String> os;
    private final Optional<String> androidAppName;
    private final Optional<String> androidAppVersion;
    private final Optional<String> androidDevice;
    private final Optional<String> androidOsVersion;
    private final Optional<String> androidSdkVersion;
    private final Optional<Integer> androidLastSeenAt;
    private final Optional<String> iosAppName;
    private final Optional<String> iosAppVersion;
    private final Optional<String> iosDevice;
    private final Optional<String> iosOsVersion;
    private final Optional<String> iosSdkVersion;
    private final Optional<Integer> iosLastSeenAt;
    private final Optional<Map<String, Object>> customAttributes;
    private final Optional<String> avatar;
    private final Optional<ContactTags> tags;
    private final Optional<ContactNotes> notes;
    private final Optional<ContactCompanies> companies;
    private final ContactLocation location;
    private final ContactSocialProfiles socialProfiles;
    private final Map<String, Object> additionalProperties;

    private Contact(Optional<String> type, String id, Optional<String> externalId, String workspaceId, String role, Optional<String> email, Optional<String> emailDomain, Optional<String> phone, Optional<String> formattedPhone, Optional<String> name, Optional<Integer> ownerId, boolean hasHardBounced, boolean markedEmailAsSpam, boolean unsubscribedFromEmails, int createdAt, int updatedAt, Optional<Integer> signedUpAt, Optional<Integer> lastSeenAt, Optional<Integer> lastRepliedAt, Optional<Integer> lastContactedAt, Optional<Integer> lastEmailOpenedAt, Optional<Integer> lastEmailClickedAt, Optional<String> languageOverride, Optional<String> browser, Optional<String> browserVersion, Optional<String> browserLanguage, Optional<String> os, Optional<String> androidAppName, Optional<String> androidAppVersion, Optional<String> androidDevice, Optional<String> androidOsVersion, Optional<String> androidSdkVersion, Optional<Integer> androidLastSeenAt, Optional<String> iosAppName, Optional<String> iosAppVersion, Optional<String> iosDevice, Optional<String> iosOsVersion, Optional<String> iosSdkVersion, Optional<Integer> iosLastSeenAt, Optional<Map<String, Object>> customAttributes, Optional<String> avatar, Optional<ContactTags> tags, Optional<ContactNotes> notes, Optional<ContactCompanies> companies, ContactLocation location, ContactSocialProfiles socialProfiles, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.externalId = externalId;
        this.workspaceId = workspaceId;
        this.role = role;
        this.email = email;
        this.emailDomain = emailDomain;
        this.phone = phone;
        this.formattedPhone = formattedPhone;
        this.name = name;
        this.ownerId = ownerId;
        this.hasHardBounced = hasHardBounced;
        this.markedEmailAsSpam = markedEmailAsSpam;
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.signedUpAt = signedUpAt;
        this.lastSeenAt = lastSeenAt;
        this.lastRepliedAt = lastRepliedAt;
        this.lastContactedAt = lastContactedAt;
        this.lastEmailOpenedAt = lastEmailOpenedAt;
        this.lastEmailClickedAt = lastEmailClickedAt;
        this.languageOverride = languageOverride;
        this.browser = browser;
        this.browserVersion = browserVersion;
        this.browserLanguage = browserLanguage;
        this.os = os;
        this.androidAppName = androidAppName;
        this.androidAppVersion = androidAppVersion;
        this.androidDevice = androidDevice;
        this.androidOsVersion = androidOsVersion;
        this.androidSdkVersion = androidSdkVersion;
        this.androidLastSeenAt = androidLastSeenAt;
        this.iosAppName = iosAppName;
        this.iosAppVersion = iosAppVersion;
        this.iosDevice = iosDevice;
        this.iosOsVersion = iosOsVersion;
        this.iosSdkVersion = iosSdkVersion;
        this.iosLastSeenAt = iosLastSeenAt;
        this.customAttributes = customAttributes;
        this.avatar = avatar;
        this.tags = tags;
        this.notes = notes;
        this.companies = companies;
        this.location = location;
        this.socialProfiles = socialProfiles;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="email_domain")
    public Optional<String> getEmailDomain() {
        return this.emailDomain;
    }

    @JsonProperty(value="phone")
    public Optional<String> getPhone() {
        return this.phone;
    }

    @JsonProperty(value="formatted_phone")
    public Optional<String> getFormattedPhone() {
        return this.formattedPhone;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="owner_id")
    public Optional<Integer> getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="has_hard_bounced")
    public boolean getHasHardBounced() {
        return this.hasHardBounced;
    }

    @JsonProperty(value="marked_email_as_spam")
    public boolean getMarkedEmailAsSpam() {
        return this.markedEmailAsSpam;
    }

    @JsonProperty(value="unsubscribed_from_emails")
    public boolean getUnsubscribedFromEmails() {
        return this.unsubscribedFromEmails;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="signed_up_at")
    public Optional<Integer> getSignedUpAt() {
        return this.signedUpAt;
    }

    @JsonProperty(value="last_seen_at")
    public Optional<Integer> getLastSeenAt() {
        return this.lastSeenAt;
    }

    @JsonProperty(value="last_replied_at")
    public Optional<Integer> getLastRepliedAt() {
        return this.lastRepliedAt;
    }

    @JsonProperty(value="last_contacted_at")
    public Optional<Integer> getLastContactedAt() {
        return this.lastContactedAt;
    }

    @JsonProperty(value="last_email_opened_at")
    public Optional<Integer> getLastEmailOpenedAt() {
        return this.lastEmailOpenedAt;
    }

    @JsonProperty(value="last_email_clicked_at")
    public Optional<Integer> getLastEmailClickedAt() {
        return this.lastEmailClickedAt;
    }

    @JsonProperty(value="language_override")
    public Optional<String> getLanguageOverride() {
        return this.languageOverride;
    }

    @JsonProperty(value="browser")
    public Optional<String> getBrowser() {
        return this.browser;
    }

    @JsonProperty(value="browser_version")
    public Optional<String> getBrowserVersion() {
        return this.browserVersion;
    }

    @JsonProperty(value="browser_language")
    public Optional<String> getBrowserLanguage() {
        return this.browserLanguage;
    }

    @JsonProperty(value="os")
    public Optional<String> getOs() {
        return this.os;
    }

    @JsonProperty(value="android_app_name")
    public Optional<String> getAndroidAppName() {
        return this.androidAppName;
    }

    @JsonProperty(value="android_app_version")
    public Optional<String> getAndroidAppVersion() {
        return this.androidAppVersion;
    }

    @JsonProperty(value="android_device")
    public Optional<String> getAndroidDevice() {
        return this.androidDevice;
    }

    @JsonProperty(value="android_os_version")
    public Optional<String> getAndroidOsVersion() {
        return this.androidOsVersion;
    }

    @JsonProperty(value="android_sdk_version")
    public Optional<String> getAndroidSdkVersion() {
        return this.androidSdkVersion;
    }

    @JsonProperty(value="android_last_seen_at")
    public Optional<Integer> getAndroidLastSeenAt() {
        return this.androidLastSeenAt;
    }

    @JsonProperty(value="ios_app_name")
    public Optional<String> getIosAppName() {
        return this.iosAppName;
    }

    @JsonProperty(value="ios_app_version")
    public Optional<String> getIosAppVersion() {
        return this.iosAppVersion;
    }

    @JsonProperty(value="ios_device")
    public Optional<String> getIosDevice() {
        return this.iosDevice;
    }

    @JsonProperty(value="ios_os_version")
    public Optional<String> getIosOsVersion() {
        return this.iosOsVersion;
    }

    @JsonProperty(value="ios_sdk_version")
    public Optional<String> getIosSdkVersion() {
        return this.iosSdkVersion;
    }

    @JsonProperty(value="ios_last_seen_at")
    public Optional<Integer> getIosLastSeenAt() {
        return this.iosLastSeenAt;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="avatar")
    public Optional<String> getAvatar() {
        return this.avatar;
    }

    @JsonProperty(value="tags")
    public Optional<ContactTags> getTags() {
        return this.tags;
    }

    @JsonProperty(value="notes")
    public Optional<ContactNotes> getNotes() {
        return this.notes;
    }

    @JsonProperty(value="companies")
    public Optional<ContactCompanies> getCompanies() {
        return this.companies;
    }

    @JsonProperty(value="location")
    public ContactLocation getLocation() {
        return this.location;
    }

    @JsonProperty(value="social_profiles")
    public ContactSocialProfiles getSocialProfiles() {
        return this.socialProfiles;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Contact && this.equalTo((Contact)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Contact other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.externalId.equals(other.externalId) && this.workspaceId.equals(other.workspaceId) && this.role.equals(other.role) && this.email.equals(other.email) && this.emailDomain.equals(other.emailDomain) && this.phone.equals(other.phone) && this.formattedPhone.equals(other.formattedPhone) && this.name.equals(other.name) && this.ownerId.equals(other.ownerId) && this.hasHardBounced == other.hasHardBounced && this.markedEmailAsSpam == other.markedEmailAsSpam && this.unsubscribedFromEmails == other.unsubscribedFromEmails && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.signedUpAt.equals(other.signedUpAt) && this.lastSeenAt.equals(other.lastSeenAt) && this.lastRepliedAt.equals(other.lastRepliedAt) && this.lastContactedAt.equals(other.lastContactedAt) && this.lastEmailOpenedAt.equals(other.lastEmailOpenedAt) && this.lastEmailClickedAt.equals(other.lastEmailClickedAt) && this.languageOverride.equals(other.languageOverride) && this.browser.equals(other.browser) && this.browserVersion.equals(other.browserVersion) && this.browserLanguage.equals(other.browserLanguage) && this.os.equals(other.os) && this.androidAppName.equals(other.androidAppName) && this.androidAppVersion.equals(other.androidAppVersion) && this.androidDevice.equals(other.androidDevice) && this.androidOsVersion.equals(other.androidOsVersion) && this.androidSdkVersion.equals(other.androidSdkVersion) && this.androidLastSeenAt.equals(other.androidLastSeenAt) && this.iosAppName.equals(other.iosAppName) && this.iosAppVersion.equals(other.iosAppVersion) && this.iosDevice.equals(other.iosDevice) && this.iosOsVersion.equals(other.iosOsVersion) && this.iosSdkVersion.equals(other.iosSdkVersion) && this.iosLastSeenAt.equals(other.iosLastSeenAt) && this.customAttributes.equals(other.customAttributes) && this.avatar.equals(other.avatar) && this.tags.equals(other.tags) && this.notes.equals(other.notes) && this.companies.equals(other.companies) && this.location.equals(other.location) && this.socialProfiles.equals(other.socialProfiles);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.externalId, this.workspaceId, this.role, this.email, this.emailDomain, this.phone, this.formattedPhone, this.name, this.ownerId, this.hasHardBounced, this.markedEmailAsSpam, this.unsubscribedFromEmails, this.createdAt, this.updatedAt, this.signedUpAt, this.lastSeenAt, this.lastRepliedAt, this.lastContactedAt, this.lastEmailOpenedAt, this.lastEmailClickedAt, this.languageOverride, this.browser, this.browserVersion, this.browserLanguage, this.os, this.androidAppName, this.androidAppVersion, this.androidDevice, this.androidOsVersion, this.androidSdkVersion, this.androidLastSeenAt, this.iosAppName, this.iosAppVersion, this.iosDevice, this.iosOsVersion, this.iosSdkVersion, this.iosLastSeenAt, this.customAttributes, this.avatar, this.tags, this.notes, this.companies, this.location, this.socialProfiles);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    WorkspaceIdStage,
    RoleStage,
    HasHardBouncedStage,
    MarkedEmailAsSpamStage,
    UnsubscribedFromEmailsStage,
    CreatedAtStage,
    UpdatedAtStage,
    LocationStage,
    SocialProfilesStage,
    _FinalStage {
        private String id;
        private String workspaceId;
        private String role;
        private boolean hasHardBounced;
        private boolean markedEmailAsSpam;
        private boolean unsubscribedFromEmails;
        private int createdAt;
        private int updatedAt;
        private ContactLocation location;
        private ContactSocialProfiles socialProfiles;
        private Optional<ContactCompanies> companies = Optional.empty();
        private Optional<ContactNotes> notes = Optional.empty();
        private Optional<ContactTags> tags = Optional.empty();
        private Optional<String> avatar = Optional.empty();
        private Optional<Map<String, Object>> customAttributes = Optional.empty();
        private Optional<Integer> iosLastSeenAt = Optional.empty();
        private Optional<String> iosSdkVersion = Optional.empty();
        private Optional<String> iosOsVersion = Optional.empty();
        private Optional<String> iosDevice = Optional.empty();
        private Optional<String> iosAppVersion = Optional.empty();
        private Optional<String> iosAppName = Optional.empty();
        private Optional<Integer> androidLastSeenAt = Optional.empty();
        private Optional<String> androidSdkVersion = Optional.empty();
        private Optional<String> androidOsVersion = Optional.empty();
        private Optional<String> androidDevice = Optional.empty();
        private Optional<String> androidAppVersion = Optional.empty();
        private Optional<String> androidAppName = Optional.empty();
        private Optional<String> os = Optional.empty();
        private Optional<String> browserLanguage = Optional.empty();
        private Optional<String> browserVersion = Optional.empty();
        private Optional<String> browser = Optional.empty();
        private Optional<String> languageOverride = Optional.empty();
        private Optional<Integer> lastEmailClickedAt = Optional.empty();
        private Optional<Integer> lastEmailOpenedAt = Optional.empty();
        private Optional<Integer> lastContactedAt = Optional.empty();
        private Optional<Integer> lastRepliedAt = Optional.empty();
        private Optional<Integer> lastSeenAt = Optional.empty();
        private Optional<Integer> signedUpAt = Optional.empty();
        private Optional<Integer> ownerId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> formattedPhone = Optional.empty();
        private Optional<String> phone = Optional.empty();
        private Optional<String> emailDomain = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<String> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Contact other) {
            this.type(other.getType());
            this.id(other.getId());
            this.externalId(other.getExternalId());
            this.workspaceId(other.getWorkspaceId());
            this.role(other.getRole());
            this.email(other.getEmail());
            this.emailDomain(other.getEmailDomain());
            this.phone(other.getPhone());
            this.formattedPhone(other.getFormattedPhone());
            this.name(other.getName());
            this.ownerId(other.getOwnerId());
            this.hasHardBounced(other.getHasHardBounced());
            this.markedEmailAsSpam(other.getMarkedEmailAsSpam());
            this.unsubscribedFromEmails(other.getUnsubscribedFromEmails());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.signedUpAt(other.getSignedUpAt());
            this.lastSeenAt(other.getLastSeenAt());
            this.lastRepliedAt(other.getLastRepliedAt());
            this.lastContactedAt(other.getLastContactedAt());
            this.lastEmailOpenedAt(other.getLastEmailOpenedAt());
            this.lastEmailClickedAt(other.getLastEmailClickedAt());
            this.languageOverride(other.getLanguageOverride());
            this.browser(other.getBrowser());
            this.browserVersion(other.getBrowserVersion());
            this.browserLanguage(other.getBrowserLanguage());
            this.os(other.getOs());
            this.androidAppName(other.getAndroidAppName());
            this.androidAppVersion(other.getAndroidAppVersion());
            this.androidDevice(other.getAndroidDevice());
            this.androidOsVersion(other.getAndroidOsVersion());
            this.androidSdkVersion(other.getAndroidSdkVersion());
            this.androidLastSeenAt(other.getAndroidLastSeenAt());
            this.iosAppName(other.getIosAppName());
            this.iosAppVersion(other.getIosAppVersion());
            this.iosDevice(other.getIosDevice());
            this.iosOsVersion(other.getIosOsVersion());
            this.iosSdkVersion(other.getIosSdkVersion());
            this.iosLastSeenAt(other.getIosLastSeenAt());
            this.customAttributes(other.getCustomAttributes());
            this.avatar(other.getAvatar());
            this.tags(other.getTags());
            this.notes(other.getNotes());
            this.companies(other.getCompanies());
            this.location(other.getLocation());
            this.socialProfiles(other.getSocialProfiles());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public RoleStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="role")
        public HasHardBouncedStage role(@NotNull String role) {
            this.role = Objects.requireNonNull(role, "role must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="has_hard_bounced")
        public MarkedEmailAsSpamStage hasHardBounced(boolean hasHardBounced) {
            this.hasHardBounced = hasHardBounced;
            return this;
        }

        @Override
        @JsonSetter(value="marked_email_as_spam")
        public UnsubscribedFromEmailsStage markedEmailAsSpam(boolean markedEmailAsSpam) {
            this.markedEmailAsSpam = markedEmailAsSpam;
            return this;
        }

        @Override
        @JsonSetter(value="unsubscribed_from_emails")
        public CreatedAtStage unsubscribedFromEmails(boolean unsubscribedFromEmails) {
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public LocationStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="location")
        public SocialProfilesStage location(@NotNull ContactLocation location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="social_profiles")
        public _FinalStage socialProfiles(@NotNull ContactSocialProfiles socialProfiles) {
            this.socialProfiles = Objects.requireNonNull(socialProfiles, "socialProfiles must not be null");
            return this;
        }

        @Override
        public _FinalStage companies(ContactCompanies companies) {
            this.companies = Optional.ofNullable(companies);
            return this;
        }

        @Override
        @JsonSetter(value="companies", nulls=Nulls.SKIP)
        public _FinalStage companies(Optional<ContactCompanies> companies) {
            this.companies = companies;
            return this;
        }

        @Override
        public _FinalStage notes(ContactNotes notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        @Override
        @JsonSetter(value="notes", nulls=Nulls.SKIP)
        public _FinalStage notes(Optional<ContactNotes> notes) {
            this.notes = notes;
            return this;
        }

        @Override
        public _FinalStage tags(ContactTags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @Override
        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public _FinalStage tags(Optional<ContactTags> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public _FinalStage avatar(String avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @Override
        @JsonSetter(value="avatar", nulls=Nulls.SKIP)
        public _FinalStage avatar(Optional<String> avatar) {
            this.avatar = avatar;
            return this;
        }

        @Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @Override
        public _FinalStage iosLastSeenAt(Integer iosLastSeenAt) {
            this.iosLastSeenAt = Optional.ofNullable(iosLastSeenAt);
            return this;
        }

        @Override
        @JsonSetter(value="ios_last_seen_at", nulls=Nulls.SKIP)
        public _FinalStage iosLastSeenAt(Optional<Integer> iosLastSeenAt) {
            this.iosLastSeenAt = iosLastSeenAt;
            return this;
        }

        @Override
        public _FinalStage iosSdkVersion(String iosSdkVersion) {
            this.iosSdkVersion = Optional.ofNullable(iosSdkVersion);
            return this;
        }

        @Override
        @JsonSetter(value="ios_sdk_version", nulls=Nulls.SKIP)
        public _FinalStage iosSdkVersion(Optional<String> iosSdkVersion) {
            this.iosSdkVersion = iosSdkVersion;
            return this;
        }

        @Override
        public _FinalStage iosOsVersion(String iosOsVersion) {
            this.iosOsVersion = Optional.ofNullable(iosOsVersion);
            return this;
        }

        @Override
        @JsonSetter(value="ios_os_version", nulls=Nulls.SKIP)
        public _FinalStage iosOsVersion(Optional<String> iosOsVersion) {
            this.iosOsVersion = iosOsVersion;
            return this;
        }

        @Override
        public _FinalStage iosDevice(String iosDevice) {
            this.iosDevice = Optional.ofNullable(iosDevice);
            return this;
        }

        @Override
        @JsonSetter(value="ios_device", nulls=Nulls.SKIP)
        public _FinalStage iosDevice(Optional<String> iosDevice) {
            this.iosDevice = iosDevice;
            return this;
        }

        @Override
        public _FinalStage iosAppVersion(String iosAppVersion) {
            this.iosAppVersion = Optional.ofNullable(iosAppVersion);
            return this;
        }

        @Override
        @JsonSetter(value="ios_app_version", nulls=Nulls.SKIP)
        public _FinalStage iosAppVersion(Optional<String> iosAppVersion) {
            this.iosAppVersion = iosAppVersion;
            return this;
        }

        @Override
        public _FinalStage iosAppName(String iosAppName) {
            this.iosAppName = Optional.ofNullable(iosAppName);
            return this;
        }

        @Override
        @JsonSetter(value="ios_app_name", nulls=Nulls.SKIP)
        public _FinalStage iosAppName(Optional<String> iosAppName) {
            this.iosAppName = iosAppName;
            return this;
        }

        @Override
        public _FinalStage androidLastSeenAt(Integer androidLastSeenAt) {
            this.androidLastSeenAt = Optional.ofNullable(androidLastSeenAt);
            return this;
        }

        @Override
        @JsonSetter(value="android_last_seen_at", nulls=Nulls.SKIP)
        public _FinalStage androidLastSeenAt(Optional<Integer> androidLastSeenAt) {
            this.androidLastSeenAt = androidLastSeenAt;
            return this;
        }

        @Override
        public _FinalStage androidSdkVersion(String androidSdkVersion) {
            this.androidSdkVersion = Optional.ofNullable(androidSdkVersion);
            return this;
        }

        @Override
        @JsonSetter(value="android_sdk_version", nulls=Nulls.SKIP)
        public _FinalStage androidSdkVersion(Optional<String> androidSdkVersion) {
            this.androidSdkVersion = androidSdkVersion;
            return this;
        }

        @Override
        public _FinalStage androidOsVersion(String androidOsVersion) {
            this.androidOsVersion = Optional.ofNullable(androidOsVersion);
            return this;
        }

        @Override
        @JsonSetter(value="android_os_version", nulls=Nulls.SKIP)
        public _FinalStage androidOsVersion(Optional<String> androidOsVersion) {
            this.androidOsVersion = androidOsVersion;
            return this;
        }

        @Override
        public _FinalStage androidDevice(String androidDevice) {
            this.androidDevice = Optional.ofNullable(androidDevice);
            return this;
        }

        @Override
        @JsonSetter(value="android_device", nulls=Nulls.SKIP)
        public _FinalStage androidDevice(Optional<String> androidDevice) {
            this.androidDevice = androidDevice;
            return this;
        }

        @Override
        public _FinalStage androidAppVersion(String androidAppVersion) {
            this.androidAppVersion = Optional.ofNullable(androidAppVersion);
            return this;
        }

        @Override
        @JsonSetter(value="android_app_version", nulls=Nulls.SKIP)
        public _FinalStage androidAppVersion(Optional<String> androidAppVersion) {
            this.androidAppVersion = androidAppVersion;
            return this;
        }

        @Override
        public _FinalStage androidAppName(String androidAppName) {
            this.androidAppName = Optional.ofNullable(androidAppName);
            return this;
        }

        @Override
        @JsonSetter(value="android_app_name", nulls=Nulls.SKIP)
        public _FinalStage androidAppName(Optional<String> androidAppName) {
            this.androidAppName = androidAppName;
            return this;
        }

        @Override
        public _FinalStage os(String os) {
            this.os = Optional.ofNullable(os);
            return this;
        }

        @Override
        @JsonSetter(value="os", nulls=Nulls.SKIP)
        public _FinalStage os(Optional<String> os) {
            this.os = os;
            return this;
        }

        @Override
        public _FinalStage browserLanguage(String browserLanguage) {
            this.browserLanguage = Optional.ofNullable(browserLanguage);
            return this;
        }

        @Override
        @JsonSetter(value="browser_language", nulls=Nulls.SKIP)
        public _FinalStage browserLanguage(Optional<String> browserLanguage) {
            this.browserLanguage = browserLanguage;
            return this;
        }

        @Override
        public _FinalStage browserVersion(String browserVersion) {
            this.browserVersion = Optional.ofNullable(browserVersion);
            return this;
        }

        @Override
        @JsonSetter(value="browser_version", nulls=Nulls.SKIP)
        public _FinalStage browserVersion(Optional<String> browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        @Override
        public _FinalStage browser(String browser) {
            this.browser = Optional.ofNullable(browser);
            return this;
        }

        @Override
        @JsonSetter(value="browser", nulls=Nulls.SKIP)
        public _FinalStage browser(Optional<String> browser) {
            this.browser = browser;
            return this;
        }

        @Override
        public _FinalStage languageOverride(String languageOverride) {
            this.languageOverride = Optional.ofNullable(languageOverride);
            return this;
        }

        @Override
        @JsonSetter(value="language_override", nulls=Nulls.SKIP)
        public _FinalStage languageOverride(Optional<String> languageOverride) {
            this.languageOverride = languageOverride;
            return this;
        }

        @Override
        public _FinalStage lastEmailClickedAt(Integer lastEmailClickedAt) {
            this.lastEmailClickedAt = Optional.ofNullable(lastEmailClickedAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_email_clicked_at", nulls=Nulls.SKIP)
        public _FinalStage lastEmailClickedAt(Optional<Integer> lastEmailClickedAt) {
            this.lastEmailClickedAt = lastEmailClickedAt;
            return this;
        }

        @Override
        public _FinalStage lastEmailOpenedAt(Integer lastEmailOpenedAt) {
            this.lastEmailOpenedAt = Optional.ofNullable(lastEmailOpenedAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_email_opened_at", nulls=Nulls.SKIP)
        public _FinalStage lastEmailOpenedAt(Optional<Integer> lastEmailOpenedAt) {
            this.lastEmailOpenedAt = lastEmailOpenedAt;
            return this;
        }

        @Override
        public _FinalStage lastContactedAt(Integer lastContactedAt) {
            this.lastContactedAt = Optional.ofNullable(lastContactedAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_contacted_at", nulls=Nulls.SKIP)
        public _FinalStage lastContactedAt(Optional<Integer> lastContactedAt) {
            this.lastContactedAt = lastContactedAt;
            return this;
        }

        @Override
        public _FinalStage lastRepliedAt(Integer lastRepliedAt) {
            this.lastRepliedAt = Optional.ofNullable(lastRepliedAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_replied_at", nulls=Nulls.SKIP)
        public _FinalStage lastRepliedAt(Optional<Integer> lastRepliedAt) {
            this.lastRepliedAt = lastRepliedAt;
            return this;
        }

        @Override
        public _FinalStage lastSeenAt(Integer lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @Override
        public _FinalStage signedUpAt(Integer signedUpAt) {
            this.signedUpAt = Optional.ofNullable(signedUpAt);
            return this;
        }

        @Override
        @JsonSetter(value="signed_up_at", nulls=Nulls.SKIP)
        public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
            this.signedUpAt = signedUpAt;
            return this;
        }

        @Override
        public _FinalStage ownerId(Integer ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        @Override
        @JsonSetter(value="owner_id", nulls=Nulls.SKIP)
        public _FinalStage ownerId(Optional<Integer> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage formattedPhone(String formattedPhone) {
            this.formattedPhone = Optional.ofNullable(formattedPhone);
            return this;
        }

        @Override
        @JsonSetter(value="formatted_phone", nulls=Nulls.SKIP)
        public _FinalStage formattedPhone(Optional<String> formattedPhone) {
            this.formattedPhone = formattedPhone;
            return this;
        }

        @Override
        public _FinalStage phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        @Override
        @JsonSetter(value="phone", nulls=Nulls.SKIP)
        public _FinalStage phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        @Override
        public _FinalStage emailDomain(String emailDomain) {
            this.emailDomain = Optional.ofNullable(emailDomain);
            return this;
        }

        @Override
        @JsonSetter(value="email_domain", nulls=Nulls.SKIP)
        public _FinalStage emailDomain(Optional<String> emailDomain) {
            this.emailDomain = emailDomain;
            return this;
        }

        @Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @Override
        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @Override
        public Contact build() {
            return new Contact(this.type, this.id, this.externalId, this.workspaceId, this.role, this.email, this.emailDomain, this.phone, this.formattedPhone, this.name, this.ownerId, this.hasHardBounced, this.markedEmailAsSpam, this.unsubscribedFromEmails, this.createdAt, this.updatedAt, this.signedUpAt, this.lastSeenAt, this.lastRepliedAt, this.lastContactedAt, this.lastEmailOpenedAt, this.lastEmailClickedAt, this.languageOverride, this.browser, this.browserVersion, this.browserLanguage, this.os, this.androidAppName, this.androidAppVersion, this.androidDevice, this.androidOsVersion, this.androidSdkVersion, this.androidLastSeenAt, this.iosAppName, this.iosAppVersion, this.iosDevice, this.iosOsVersion, this.iosSdkVersion, this.iosLastSeenAt, this.customAttributes, this.avatar, this.tags, this.notes, this.companies, this.location, this.socialProfiles, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Contact build();

        public _FinalStage type(Optional<String> var1);

        public _FinalStage type(String var1);

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);

        public _FinalStage email(Optional<String> var1);

        public _FinalStage email(String var1);

        public _FinalStage emailDomain(Optional<String> var1);

        public _FinalStage emailDomain(String var1);

        public _FinalStage phone(Optional<String> var1);

        public _FinalStage phone(String var1);

        public _FinalStage formattedPhone(Optional<String> var1);

        public _FinalStage formattedPhone(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage ownerId(Optional<Integer> var1);

        public _FinalStage ownerId(Integer var1);

        public _FinalStage signedUpAt(Optional<Integer> var1);

        public _FinalStage signedUpAt(Integer var1);

        public _FinalStage lastSeenAt(Optional<Integer> var1);

        public _FinalStage lastSeenAt(Integer var1);

        public _FinalStage lastRepliedAt(Optional<Integer> var1);

        public _FinalStage lastRepliedAt(Integer var1);

        public _FinalStage lastContactedAt(Optional<Integer> var1);

        public _FinalStage lastContactedAt(Integer var1);

        public _FinalStage lastEmailOpenedAt(Optional<Integer> var1);

        public _FinalStage lastEmailOpenedAt(Integer var1);

        public _FinalStage lastEmailClickedAt(Optional<Integer> var1);

        public _FinalStage lastEmailClickedAt(Integer var1);

        public _FinalStage languageOverride(Optional<String> var1);

        public _FinalStage languageOverride(String var1);

        public _FinalStage browser(Optional<String> var1);

        public _FinalStage browser(String var1);

        public _FinalStage browserVersion(Optional<String> var1);

        public _FinalStage browserVersion(String var1);

        public _FinalStage browserLanguage(Optional<String> var1);

        public _FinalStage browserLanguage(String var1);

        public _FinalStage os(Optional<String> var1);

        public _FinalStage os(String var1);

        public _FinalStage androidAppName(Optional<String> var1);

        public _FinalStage androidAppName(String var1);

        public _FinalStage androidAppVersion(Optional<String> var1);

        public _FinalStage androidAppVersion(String var1);

        public _FinalStage androidDevice(Optional<String> var1);

        public _FinalStage androidDevice(String var1);

        public _FinalStage androidOsVersion(Optional<String> var1);

        public _FinalStage androidOsVersion(String var1);

        public _FinalStage androidSdkVersion(Optional<String> var1);

        public _FinalStage androidSdkVersion(String var1);

        public _FinalStage androidLastSeenAt(Optional<Integer> var1);

        public _FinalStage androidLastSeenAt(Integer var1);

        public _FinalStage iosAppName(Optional<String> var1);

        public _FinalStage iosAppName(String var1);

        public _FinalStage iosAppVersion(Optional<String> var1);

        public _FinalStage iosAppVersion(String var1);

        public _FinalStage iosDevice(Optional<String> var1);

        public _FinalStage iosDevice(String var1);

        public _FinalStage iosOsVersion(Optional<String> var1);

        public _FinalStage iosOsVersion(String var1);

        public _FinalStage iosSdkVersion(Optional<String> var1);

        public _FinalStage iosSdkVersion(String var1);

        public _FinalStage iosLastSeenAt(Optional<Integer> var1);

        public _FinalStage iosLastSeenAt(Integer var1);

        public _FinalStage customAttributes(Optional<Map<String, Object>> var1);

        public _FinalStage customAttributes(Map<String, Object> var1);

        public _FinalStage avatar(Optional<String> var1);

        public _FinalStage avatar(String var1);

        public _FinalStage tags(Optional<ContactTags> var1);

        public _FinalStage tags(ContactTags var1);

        public _FinalStage notes(Optional<ContactNotes> var1);

        public _FinalStage notes(ContactNotes var1);

        public _FinalStage companies(Optional<ContactCompanies> var1);

        public _FinalStage companies(ContactCompanies var1);
    }

    public static interface SocialProfilesStage {
        public _FinalStage socialProfiles(@NotNull ContactSocialProfiles var1);
    }

    public static interface LocationStage {
        public SocialProfilesStage location(@NotNull ContactLocation var1);
    }

    public static interface UpdatedAtStage {
        public LocationStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface UnsubscribedFromEmailsStage {
        public CreatedAtStage unsubscribedFromEmails(boolean var1);
    }

    public static interface MarkedEmailAsSpamStage {
        public UnsubscribedFromEmailsStage markedEmailAsSpam(boolean var1);
    }

    public static interface HasHardBouncedStage {
        public MarkedEmailAsSpamStage hasHardBounced(boolean var1);
    }

    public static interface RoleStage {
        public HasHardBouncedStage role(@NotNull String var1);
    }

    public static interface WorkspaceIdStage {
        public RoleStage workspaceId(@NotNull String var1);
    }

    public static interface IdStage {
        public WorkspaceIdStage id(@NotNull String var1);

        public Builder from(Contact var1);
    }
}

