/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.conversations.RawConversationsClient;
import com.intercom.api.resources.conversations.requests.AttachContactToConversationRequest;
import com.intercom.api.resources.conversations.requests.AutoAssignConversationRequest;
import com.intercom.api.resources.conversations.requests.ConvertConversationToTicketRequest;
import com.intercom.api.resources.conversations.requests.CreateConversationRequest;
import com.intercom.api.resources.conversations.requests.DetachContactFromConversationRequest;
import com.intercom.api.resources.conversations.requests.FindConversationRequest;
import com.intercom.api.resources.conversations.requests.ListConversationsRequest;
import com.intercom.api.resources.conversations.requests.ManageConversationPartsRequest;
import com.intercom.api.resources.conversations.requests.ReplyToConversationRequest;
import com.intercom.api.resources.conversations.requests.UpdateConversationRequest;
import com.intercom.api.resources.conversations.types.Conversation;
import com.intercom.api.resources.messages.types.Message;
import com.intercom.api.resources.tickets.types.Ticket;
import com.intercom.api.types.RedactConversationRequest;
import com.intercom.api.types.SearchRequest;

public class ConversationsClient {
    protected final ClientOptions clientOptions;
    private final RawConversationsClient rawClient;

    public ConversationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawConversationsClient(clientOptions);
    }

    public RawConversationsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Conversation> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Conversation> list(ListConversationsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Conversation> list(ListConversationsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public Message create(CreateConversationRequest request) {
        return this.rawClient.create(request).body();
    }

    public Message create(CreateConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public Conversation find(FindConversationRequest request) {
        return this.rawClient.find(request).body();
    }

    public Conversation find(FindConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public Conversation update(UpdateConversationRequest request) {
        return this.rawClient.update(request).body();
    }

    public Conversation update(UpdateConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public SyncPagingIterable<Conversation> search(SearchRequest request) {
        return this.rawClient.search(request).body();
    }

    public SyncPagingIterable<Conversation> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }

    public Conversation reply(ReplyToConversationRequest request) {
        return this.rawClient.reply(request).body();
    }

    public Conversation reply(ReplyToConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.reply(request, requestOptions).body();
    }

    public Conversation manage(ManageConversationPartsRequest request) {
        return this.rawClient.manage(request).body();
    }

    public Conversation manage(ManageConversationPartsRequest request, RequestOptions requestOptions) {
        return this.rawClient.manage(request, requestOptions).body();
    }

    public Conversation runAssignmentRules(AutoAssignConversationRequest request) {
        return this.rawClient.runAssignmentRules(request).body();
    }

    public Conversation runAssignmentRules(AutoAssignConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.runAssignmentRules(request, requestOptions).body();
    }

    public Conversation attachContactAsAdmin(AttachContactToConversationRequest request) {
        return this.rawClient.attachContactAsAdmin(request).body();
    }

    public Conversation attachContactAsAdmin(AttachContactToConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContactAsAdmin(request, requestOptions).body();
    }

    public Conversation detachContactAsAdmin(DetachContactFromConversationRequest request) {
        return this.rawClient.detachContactAsAdmin(request).body();
    }

    public Conversation detachContactAsAdmin(DetachContactFromConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContactAsAdmin(request, requestOptions).body();
    }

    public Conversation redactConversationPart(RedactConversationRequest request) {
        return this.rawClient.redactConversationPart(request).body();
    }

    public Conversation redactConversationPart(RedactConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.redactConversationPart(request, requestOptions).body();
    }

    public Ticket convertToTicket(ConvertConversationToTicketRequest request) {
        return this.rawClient.convertToTicket(request).body();
    }

    public Ticket convertToTicket(ConvertConversationToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.convertToTicket(request, requestOptions).body();
    }
}

