/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.news.items;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.news.items.AsyncRawItemsClient;
import com.intercom.api.resources.news.items.requests.DeleteNewsItemRequest;
import com.intercom.api.resources.news.items.requests.FindNewsItemRequest;
import com.intercom.api.resources.news.items.requests.UpdateNewsItemRequest;
import com.intercom.api.resources.news.types.NewsItem;
import com.intercom.api.types.DeletedObject;
import com.intercom.api.types.NewsItemRequest;
import com.intercom.api.types.PaginatedNewsItemResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncItemsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawItemsClient rawClient;

    public AsyncItemsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawItemsClient(clientOptions);
    }

    public AsyncRawItemsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<PaginatedNewsItemResponse> list() {
        return this.rawClient.list().thenApply(response -> (PaginatedNewsItemResponse)response.body());
    }

    public CompletableFuture<PaginatedNewsItemResponse> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (PaginatedNewsItemResponse)response.body());
    }

    public CompletableFuture<NewsItem> create(NewsItemRequest request) {
        return this.rawClient.create(request).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> create(NewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> find(FindNewsItemRequest request) {
        return this.rawClient.find(request).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> find(FindNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> update(UpdateNewsItemRequest request) {
        return this.rawClient.update(request).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<NewsItem> update(UpdateNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (NewsItem)response.body());
    }

    public CompletableFuture<DeletedObject> delete(DeleteNewsItemRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeletedObject)response.body());
    }

    public CompletableFuture<DeletedObject> delete(DeleteNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeletedObject)response.body());
    }
}

