/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.news.items.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.NewsItemRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateNewsItemRequest {
    private final String newsItemId;
    private final NewsItemRequest body;
    private final Map<String, Object> additionalProperties;

    private UpdateNewsItemRequest(String newsItemId, NewsItemRequest body, Map<String, Object> additionalProperties) {
        this.newsItemId = newsItemId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="news_item_id")
    public String getNewsItemId() {
        return this.newsItemId;
    }

    @JsonProperty(value="body")
    public NewsItemRequest getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateNewsItemRequest && this.equalTo((UpdateNewsItemRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateNewsItemRequest other) {
        return this.newsItemId.equals(other.newsItemId) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.newsItemId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NewsItemIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NewsItemIdStage,
    BodyStage,
    _FinalStage {
        private String newsItemId;
        private NewsItemRequest body;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateNewsItemRequest other) {
            this.newsItemId(other.getNewsItemId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="news_item_id")
        public BodyStage newsItemId(@NotNull String newsItemId) {
            this.newsItemId = Objects.requireNonNull(newsItemId, "newsItemId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull NewsItemRequest body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public UpdateNewsItemRequest build() {
            return new UpdateNewsItemRequest(this.newsItemId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateNewsItemRequest build();
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull NewsItemRequest var1);
    }

    public static interface NewsItemIdStage {
        public BodyStage newsItemId(@NotNull String var1);

        public Builder from(UpdateNewsItemRequest var1);
    }
}

