/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tags.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Tag {
    private final String id;
    private final String name;
    private final int appliedAt;
    private final Reference appliedBy;
    private final Map<String, Object> additionalProperties;

    private Tag(String id, String name, int appliedAt, Reference appliedBy, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.appliedAt = appliedAt;
        this.appliedBy = appliedBy;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "tag";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="applied_at")
    public int getAppliedAt() {
        return this.appliedAt;
    }

    @JsonProperty(value="applied_by")
    public Reference getAppliedBy() {
        return this.appliedBy;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Tag && this.equalTo((Tag)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Tag other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.appliedAt == other.appliedAt && this.appliedBy.equals(other.appliedBy);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.appliedAt, this.appliedBy);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    AppliedAtStage,
    AppliedByStage,
    _FinalStage {
        private String id;
        private String name;
        private int appliedAt;
        private Reference appliedBy;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Tag other) {
            this.id(other.getId());
            this.name(other.getName());
            this.appliedAt(other.getAppliedAt());
            this.appliedBy(other.getAppliedBy());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public AppliedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="applied_at")
        public AppliedByStage appliedAt(int appliedAt) {
            this.appliedAt = appliedAt;
            return this;
        }

        @Override
        @JsonSetter(value="applied_by")
        public _FinalStage appliedBy(@NotNull Reference appliedBy) {
            this.appliedBy = Objects.requireNonNull(appliedBy, "appliedBy must not be null");
            return this;
        }

        @Override
        public Tag build() {
            return new Tag(this.id, this.name, this.appliedAt, this.appliedBy, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Tag build();
    }

    public static interface AppliedByStage {
        public _FinalStage appliedBy(@NotNull Reference var1);
    }

    public static interface AppliedAtStage {
        public AppliedByStage appliedAt(int var1);
    }

    public static interface NameStage {
        public AppliedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Tag var1);
    }
}

