/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.tickets.RawTicketsClient;
import com.intercom.api.resources.tickets.requests.FindTicketRequest;
import com.intercom.api.resources.tickets.requests.ReplyToTicketRequest;
import com.intercom.api.resources.tickets.requests.UpdateTicketRequest;
import com.intercom.api.resources.tickets.types.Ticket;
import com.intercom.api.types.CreateTicketRequest;
import com.intercom.api.types.SearchRequest;
import com.intercom.api.types.TicketReply;

public class TicketsClient {
    protected final ClientOptions clientOptions;
    private final RawTicketsClient rawClient;

    public TicketsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTicketsClient(clientOptions);
    }

    public RawTicketsClient withRawResponse() {
        return this.rawClient;
    }

    public TicketReply reply(ReplyToTicketRequest request) {
        return this.rawClient.reply(request).body();
    }

    public TicketReply reply(ReplyToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.reply(request, requestOptions).body();
    }

    public Ticket create(CreateTicketRequest request) {
        return this.rawClient.create(request).body();
    }

    public Ticket create(CreateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public Ticket get(FindTicketRequest request) {
        return this.rawClient.get(request).body();
    }

    public Ticket get(FindTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public Ticket update(UpdateTicketRequest request) {
        return this.rawClient.update(request).body();
    }

    public Ticket update(UpdateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public SyncPagingIterable<Ticket> search(SearchRequest request) {
        return this.rawClient.search(request).body();
    }

    public SyncPagingIterable<Ticket> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }
}

