/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickettypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.Suppliers;
import com.intercom.api.resources.tickets.types.TicketType;
import com.intercom.api.resources.tickettypes.RawTicketTypesClient;
import com.intercom.api.resources.tickettypes.attributes.AttributesClient;
import com.intercom.api.resources.tickettypes.requests.CreateTicketTypeRequest;
import com.intercom.api.resources.tickettypes.requests.FindTicketTypeRequest;
import com.intercom.api.resources.tickettypes.requests.UpdateTicketTypeRequest;
import com.intercom.api.types.TicketTypeList;
import java.util.function.Supplier;

public class TicketTypesClient {
    protected final ClientOptions clientOptions;
    private final RawTicketTypesClient rawClient;
    protected final Supplier<AttributesClient> attributesClient;

    public TicketTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTicketTypesClient(clientOptions);
        this.attributesClient = Suppliers.memoize(() -> new AttributesClient(clientOptions));
    }

    public RawTicketTypesClient withRawResponse() {
        return this.rawClient;
    }

    public TicketTypeList list() {
        return this.rawClient.list().body();
    }

    public TicketTypeList list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public TicketType create(CreateTicketTypeRequest request) {
        return this.rawClient.create(request).body();
    }

    public TicketType create(CreateTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public TicketType get(FindTicketTypeRequest request) {
        return this.rawClient.get(request).body();
    }

    public TicketType get(FindTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public TicketType update(UpdateTicketTypeRequest request) {
        return this.rawClient.update(request).body();
    }

    public TicketType update(UpdateTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public AttributesClient attributes() {
        return this.attributesClient.get();
    }
}

