/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConvertConversationToTicketRequest {
    private final int id;
    private final String ticketTypeId;
    private final Optional<Map<String, AttributesValue>> attributes;
    private final Map<String, Object> additionalProperties;

    private ConvertConversationToTicketRequest(int id, String ticketTypeId, Optional<Map<String, AttributesValue>> attributes, Map<String, Object> additionalProperties) {
        this.id = id;
        this.ticketTypeId = ticketTypeId;
        this.attributes = attributes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="ticket_type_id")
    public String getTicketTypeId() {
        return this.ticketTypeId;
    }

    @JsonProperty(value="attributes")
    public Optional<Map<String, AttributesValue>> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConvertConversationToTicketRequest && this.equalTo((ConvertConversationToTicketRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConvertConversationToTicketRequest other) {
        return this.id == other.id && this.ticketTypeId.equals(other.ticketTypeId) && this.attributes.equals(other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ticketTypeId, this.attributes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class AttributesValue {
        private final Object value;
        private final int type;

        private AttributesValue(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((Optional)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((Double)this.value);
            }
            if (this.type == 2) {
                return visitor.visit((Boolean)this.value);
            }
            if (this.type == 3) {
                return visitor.visit((List)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof AttributesValue && this.equalTo((AttributesValue)other);
        }

        private boolean equalTo(AttributesValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static AttributesValue of(Optional<String> value) {
            return new AttributesValue(value, 0);
        }

        public static AttributesValue of(double value) {
            return new AttributesValue(value, 1);
        }

        public static AttributesValue of(boolean value) {
            return new AttributesValue(value, 2);
        }

        public static AttributesValue of(List<Object> value) {
            return new AttributesValue(value, 3);
        }

        static final class Deserializer
        extends StdDeserializer<AttributesValue> {
            Deserializer() {
                super(AttributesValue.class);
            }

            public AttributesValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return AttributesValue.of((Optional)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Optional<String>>(){}));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (value instanceof Double) {
                        return AttributesValue.of((Double)value);
                    }
                    if (value instanceof Boolean) {
                        return AttributesValue.of((Boolean)value);
                    }
                    try {
                        return AttributesValue.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<Object>>(){}));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(Optional<String> var1);

            public T visit(double var1);

            public T visit(boolean var1);

            public T visit(List<Object> var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TicketTypeIdStage,
    _FinalStage {
        private int id;
        private String ticketTypeId;
        private Optional<Map<String, AttributesValue>> attributes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConvertConversationToTicketRequest other) {
            this.id(other.getId());
            this.ticketTypeId(other.getTicketTypeId());
            this.attributes(other.getAttributes());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TicketTypeIdStage id(int id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type_id")
        public _FinalStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @Override
        public _FinalStage attributes(Map<String, AttributesValue> attributes) {
            this.attributes = Optional.ofNullable(attributes);
            return this;
        }

        @Override
        @JsonSetter(value="attributes", nulls=Nulls.SKIP)
        public _FinalStage attributes(Optional<Map<String, AttributesValue>> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public ConvertConversationToTicketRequest build() {
            return new ConvertConversationToTicketRequest(this.id, this.ticketTypeId, this.attributes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConvertConversationToTicketRequest build();

        public _FinalStage attributes(Optional<Map<String, AttributesValue>> var1);

        public _FinalStage attributes(Map<String, AttributesValue> var1);
    }

    public static interface TicketTypeIdStage {
        public _FinalStage ticketTypeId(@NotNull String var1);
    }

    public static interface IdStage {
        public TicketTypeIdStage id(int var1);

        public Builder from(ConvertConversationToTicketRequest var1);
    }
}

