/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataattributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateDataAttributeRequest {
    private final String name;
    private final Model model;
    private final DataType dataType;
    private final Optional<String> description;
    private final Optional<List<String>> options;
    private final Optional<Boolean> messengerWritable;
    private final Map<String, Object> additionalProperties;

    private CreateDataAttributeRequest(String name, Model model, DataType dataType, Optional<String> description, Optional<List<String>> options, Optional<Boolean> messengerWritable, Map<String, Object> additionalProperties) {
        this.name = name;
        this.model = model;
        this.dataType = dataType;
        this.description = description;
        this.options = options;
        this.messengerWritable = messengerWritable;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="model")
    public Model getModel() {
        return this.model;
    }

    @JsonProperty(value="data_type")
    public DataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="options")
    public Optional<List<String>> getOptions() {
        return this.options;
    }

    @JsonProperty(value="messenger_writable")
    public Optional<Boolean> getMessengerWritable() {
        return this.messengerWritable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDataAttributeRequest && this.equalTo((CreateDataAttributeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDataAttributeRequest other) {
        return this.name.equals(other.name) && this.model.equals(other.model) && this.dataType.equals(other.dataType) && this.description.equals(other.description) && this.options.equals(other.options) && this.messengerWritable.equals(other.messengerWritable);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.model, this.dataType, this.description, this.options, this.messengerWritable);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");
        public static final DataType FLOAT = new DataType(Value.FLOAT, "float");
        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");
        public static final DataType DATETIME = new DataType(Value.DATETIME, "datetime");
        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");
        public static final DataType DATE = new DataType(Value.DATE, "date");
        private final Value value;
        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DataType && this.string.equals(((DataType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case STRING: {
                    return visitor.visitString();
                }
                case FLOAT: {
                    return visitor.visitFloat();
                }
                case INTEGER: {
                    return visitor.visitInteger();
                }
                case DATETIME: {
                    return visitor.visitDatetime();
                }
                case BOOLEAN: {
                    return visitor.visitBoolean();
                }
                case DATE: {
                    return visitor.visitDate();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string": {
                    return STRING;
                }
                case "float": {
                    return FLOAT;
                }
                case "integer": {
                    return INTEGER;
                }
                case "datetime": {
                    return DATETIME;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "date": {
                    return DATE;
                }
            }
            return new DataType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitString();

            public T visitInteger();

            public T visitFloat();

            public T visitBoolean();

            public T visitDatetime();

            public T visitDate();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            STRING,
            INTEGER,
            FLOAT,
            BOOLEAN,
            DATETIME,
            DATE,
            UNKNOWN;

        }
    }

    public static final class Model {
        public static final Model CONTACT = new Model(Value.CONTACT, "contact");
        public static final Model COMPANY = new Model(Value.COMPANY, "company");
        private final Value value;
        private final String string;

        Model(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Model && this.string.equals(((Model)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case CONTACT: {
                    return visitor.visitContact();
                }
                case COMPANY: {
                    return visitor.visitCompany();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Model valueOf(String value) {
            switch (value) {
                case "contact": {
                    return CONTACT;
                }
                case "company": {
                    return COMPANY;
                }
            }
            return new Model(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitContact();

            public T visitCompany();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CONTACT,
            COMPANY,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    ModelStage,
    DataTypeStage,
    _FinalStage {
        private String name;
        private Model model;
        private DataType dataType;
        private Optional<Boolean> messengerWritable = Optional.empty();
        private Optional<List<String>> options = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateDataAttributeRequest other) {
            this.name(other.getName());
            this.model(other.getModel());
            this.dataType(other.getDataType());
            this.description(other.getDescription());
            this.options(other.getOptions());
            this.messengerWritable(other.getMessengerWritable());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public ModelStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public DataTypeStage model(@NotNull Model model) {
            this.model = Objects.requireNonNull(model, "model must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="data_type")
        public _FinalStage dataType(@NotNull DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            return this;
        }

        @Override
        public _FinalStage messengerWritable(Boolean messengerWritable) {
            this.messengerWritable = Optional.ofNullable(messengerWritable);
            return this;
        }

        @Override
        @JsonSetter(value="messenger_writable", nulls=Nulls.SKIP)
        public _FinalStage messengerWritable(Optional<Boolean> messengerWritable) {
            this.messengerWritable = messengerWritable;
            return this;
        }

        @Override
        public _FinalStage options(List<String> options) {
            this.options = Optional.ofNullable(options);
            return this;
        }

        @Override
        @JsonSetter(value="options", nulls=Nulls.SKIP)
        public _FinalStage options(Optional<List<String>> options) {
            this.options = options;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public CreateDataAttributeRequest build() {
            return new CreateDataAttributeRequest(this.name, this.model, this.dataType, this.description, this.options, this.messengerWritable, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateDataAttributeRequest build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage options(Optional<List<String>> var1);

        public _FinalStage options(List<String> var1);

        public _FinalStage messengerWritable(Optional<Boolean> var1);

        public _FinalStage messengerWritable(Boolean var1);
    }

    public static interface DataTypeStage {
        public _FinalStage dataType(@NotNull DataType var1);
    }

    public static interface ModelStage {
        public DataTypeStage model(@NotNull Model var1);
    }

    public static interface NameStage {
        public ModelStage name(@NotNull String var1);

        public Builder from(CreateDataAttributeRequest var1);
    }
}

