/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.helpcenter;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.helpcenter.AsyncRawHelpCenterClient;
import com.intercom.api.resources.unstable.helpcenter.requests.CreateCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.DeleteCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.RetrieveCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.RetrieveHelpCenterRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.UpdateCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.types.Collection;
import com.intercom.api.resources.unstable.helpcenter.types.HelpCenter;
import com.intercom.api.resources.unstable.helpcenter.types.HelpCenterList;
import com.intercom.api.resources.unstable.types.CollectionList;
import com.intercom.api.resources.unstable.types.DeletedCollectionObject;
import java.util.concurrent.CompletableFuture;

public class AsyncHelpCenterClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawHelpCenterClient rawClient;

    public AsyncHelpCenterClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawHelpCenterClient(clientOptions);
    }

    public AsyncRawHelpCenterClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CollectionList> listAllCollections() {
        return this.rawClient.listAllCollections().thenApply(response -> (CollectionList)response.body());
    }

    public CompletableFuture<CollectionList> listAllCollections(RequestOptions requestOptions) {
        return this.rawClient.listAllCollections(requestOptions).thenApply(response -> (CollectionList)response.body());
    }

    public CompletableFuture<Collection> createCollection(CreateCollectionRequest request) {
        return this.rawClient.createCollection(request).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> createCollection(CreateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.createCollection(request, requestOptions).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> retrieveCollection(RetrieveCollectionRequest request) {
        return this.rawClient.retrieveCollection(request).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> retrieveCollection(RetrieveCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveCollection(request, requestOptions).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> updateCollection(UpdateCollectionRequest request) {
        return this.rawClient.updateCollection(request).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> updateCollection(UpdateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateCollection(request, requestOptions).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<DeletedCollectionObject> deleteCollection(DeleteCollectionRequest request) {
        return this.rawClient.deleteCollection(request).thenApply(response -> (DeletedCollectionObject)response.body());
    }

    public CompletableFuture<DeletedCollectionObject> deleteCollection(DeleteCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteCollection(request, requestOptions).thenApply(response -> (DeletedCollectionObject)response.body());
    }

    public CompletableFuture<HelpCenter> retrieveHelpCenter(RetrieveHelpCenterRequest request) {
        return this.rawClient.retrieveHelpCenter(request).thenApply(response -> (HelpCenter)response.body());
    }

    public CompletableFuture<HelpCenter> retrieveHelpCenter(RetrieveHelpCenterRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveHelpCenter(request, requestOptions).thenApply(response -> (HelpCenter)response.body());
    }

    public CompletableFuture<HelpCenterList> listHelpCenters() {
        return this.rawClient.listHelpCenters().thenApply(response -> (HelpCenterList)response.body());
    }

    public CompletableFuture<HelpCenterList> listHelpCenters(RequestOptions requestOptions) {
        return this.rawClient.listHelpCenters(requestOptions).thenApply(response -> (HelpCenterList)response.body());
    }
}

