/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.IQuickReplyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class QuickReplyOption
implements IQuickReplyOption {
    private final String text;
    private final String uuid;
    private final Map<String, Object> additionalProperties;

    private QuickReplyOption(String text, String uuid, Map<String, Object> additionalProperties) {
        this.text = text;
        this.uuid = uuid;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="uuid")
    public String getUuid() {
        return this.uuid;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof QuickReplyOption && this.equalTo((QuickReplyOption)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(QuickReplyOption other) {
        return this.text.equals(other.text) && this.uuid.equals(other.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.uuid);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    UuidStage,
    _FinalStage {
        private String text;
        private String uuid;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(QuickReplyOption other) {
            this.text(other.getText());
            this.uuid(other.getUuid());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public UuidStage text(@NotNull String text) {
            this.text = Objects.requireNonNull(text, "text must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="uuid")
        public _FinalStage uuid(@NotNull String uuid) {
            this.uuid = Objects.requireNonNull(uuid, "uuid must not be null");
            return this;
        }

        @Override
        public QuickReplyOption build() {
            return new QuickReplyOption(this.text, this.uuid, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public QuickReplyOption build();
    }

    public static interface UuidStage {
        public _FinalStage uuid(@NotNull String var1);
    }

    public static interface TextStage {
        public UuidStage text(@NotNull String var1);

        public Builder from(QuickReplyOption var1);
    }
}

