/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ArticleTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateArticleRequestBody {
    private final Optional<String> title;
    private final Optional<String> description;
    private final Optional<String> body;
    private final Optional<Integer> authorId;
    private final Optional<State> state;
    private final Optional<String> parentId;
    private final Optional<String> parentType;
    private final Optional<ArticleTranslatedContent> translatedContent;
    private final Map<String, Object> additionalProperties;

    private UpdateArticleRequestBody(Optional<String> title, Optional<String> description, Optional<String> body, Optional<Integer> authorId, Optional<State> state, Optional<String> parentId, Optional<String> parentType, Optional<ArticleTranslatedContent> translatedContent, Map<String, Object> additionalProperties) {
        this.title = title;
        this.description = description;
        this.body = body;
        this.authorId = authorId;
        this.state = state;
        this.parentId = parentId;
        this.parentType = parentType;
        this.translatedContent = translatedContent;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="author_id")
    public Optional<Integer> getAuthorId() {
        return this.authorId;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="parent_id")
    public Optional<String> getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="parent_type")
    public Optional<String> getParentType() {
        return this.parentType;
    }

    @JsonProperty(value="translated_content")
    public Optional<ArticleTranslatedContent> getTranslatedContent() {
        return this.translatedContent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateArticleRequestBody && this.equalTo((UpdateArticleRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateArticleRequestBody other) {
        return this.title.equals(other.title) && this.description.equals(other.description) && this.body.equals(other.body) && this.authorId.equals(other.authorId) && this.state.equals(other.state) && this.parentId.equals(other.parentId) && this.parentType.equals(other.parentType) && this.translatedContent.equals(other.translatedContent);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.body, this.authorId, this.state, this.parentId, this.parentType, this.translatedContent);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class State {
        public static final State PUBLISHED = new State(Value.PUBLISHED, "published");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PUBLISHED: {
                    return visitor.visitPublished();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "published": {
                    return PUBLISHED;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPublished();

            public T visitDraft();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PUBLISHED,
            DRAFT,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> title = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<Integer> authorId = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<String> parentId = Optional.empty();
        private Optional<String> parentType = Optional.empty();
        private Optional<ArticleTranslatedContent> translatedContent = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateArticleRequestBody other) {
            this.title(other.getTitle());
            this.description(other.getDescription());
            this.body(other.getBody());
            this.authorId(other.getAuthorId());
            this.state(other.getState());
            this.parentId(other.getParentId());
            this.parentType(other.getParentType());
            this.translatedContent(other.getTranslatedContent());
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @JsonSetter(value="author_id", nulls=Nulls.SKIP)
        public Builder authorId(Optional<Integer> authorId) {
            this.authorId = authorId;
            return this;
        }

        public Builder authorId(Integer authorId) {
            this.authorId = Optional.ofNullable(authorId);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="parent_id", nulls=Nulls.SKIP)
        public Builder parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        @JsonSetter(value="parent_type", nulls=Nulls.SKIP)
        public Builder parentType(Optional<String> parentType) {
            this.parentType = parentType;
            return this;
        }

        public Builder parentType(String parentType) {
            this.parentType = Optional.ofNullable(parentType);
            return this;
        }

        @JsonSetter(value="translated_content", nulls=Nulls.SKIP)
        public Builder translatedContent(Optional<ArticleTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        public Builder translatedContent(ArticleTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        public UpdateArticleRequestBody build() {
            return new UpdateArticleRequestBody(this.title, this.description, this.body, this.authorId, this.state, this.parentId, this.parentType, this.translatedContent, this.additionalProperties);
        }
    }
}

