/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ArticleContent {
    private final String title;
    private final String description;
    private final String body;
    private final int authorId;
    private final State state;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<String> url;
    private final Map<String, Object> additionalProperties;

    private ArticleContent(String title, String description, String body, int authorId, State state, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<String> url, Map<String, Object> additionalProperties) {
        this.title = title;
        this.description = description;
        this.body = body;
        this.authorId = authorId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "article_content";
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="author_id")
    public int getAuthorId() {
        return this.authorId;
    }

    @JsonProperty(value="state")
    public State getState() {
        return this.state;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ArticleContent && this.equalTo((ArticleContent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleContent other) {
        return this.title.equals(other.title) && this.description.equals(other.description) && this.body.equals(other.body) && this.authorId == other.authorId && this.state.equals(other.state) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.body, this.authorId, this.state, this.createdAt, this.updatedAt, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    public static final class State {
        public static final State PUBLISHED = new State(Value.PUBLISHED, "published");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PUBLISHED: {
                    return visitor.visitPublished();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "published": {
                    return PUBLISHED;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPublished();

            public T visitDraft();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PUBLISHED,
            DRAFT,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    DescriptionStage,
    BodyStage,
    AuthorIdStage,
    StateStage,
    _FinalStage {
        private String title;
        private String description;
        private String body;
        private int authorId;
        private State state;
        private Optional<String> url = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ArticleContent other) {
            this.title(other.getTitle());
            this.description(other.getDescription());
            this.body(other.getBody());
            this.authorId(other.getAuthorId());
            this.state(other.getState());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public DescriptionStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public BodyStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public AuthorIdStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="author_id")
        public StateStage authorId(int authorId) {
            this.authorId = authorId;
            return this;
        }

        @Override
        @JsonSetter(value="state")
        public _FinalStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public ArticleContent build() {
            return new ArticleContent(this.title, this.description, this.body, this.authorId, this.state, this.createdAt, this.updatedAt, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ArticleContent build();

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);
    }

    public static interface StateStage {
        public _FinalStage state(@NotNull State var1);
    }

    public static interface AuthorIdStage {
        public StateStage authorId(int var1);
    }

    public static interface BodyStage {
        public AuthorIdStage body(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public BodyStage description(@NotNull String var1);
    }

    public static interface TitleStage {
        public DescriptionStage title(@NotNull String var1);

        public Builder from(ArticleContent var1);
    }
}

