/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.types.OffsetPages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyList {
    private final Optional<OffsetPages> pages;
    private final int totalCount;
    private final List<Company> data;
    private final Map<String, Object> additionalProperties;

    private CompanyList(Optional<OffsetPages> pages, int totalCount, List<Company> data, Map<String, Object> additionalProperties) {
        this.pages = pages;
        this.totalCount = totalCount;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="pages")
    public Optional<OffsetPages> getPages() {
        return this.pages;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="data")
    public List<Company> getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyList && this.equalTo((CompanyList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyList other) {
        return this.pages.equals(other.pages) && this.totalCount == other.totalCount && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.pages, this.totalCount, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private List<Company> data = new ArrayList<Company>();
        private Optional<OffsetPages> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyList other) {
            this.pages(other.getPages());
            this.totalCount(other.getTotalCount());
            this.data(other.getData());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllData(List<Company> data) {
            this.data.addAll(data);
            return this;
        }

        @Override
        public _FinalStage addData(Company data) {
            this.data.add(data);
            return this;
        }

        @Override
        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public _FinalStage data(List<Company> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @Override
        public _FinalStage pages(OffsetPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @Override
        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public _FinalStage pages(Optional<OffsetPages> pages) {
            this.pages = pages;
            return this;
        }

        @Override
        public CompanyList build() {
            return new CompanyList(this.pages, this.totalCount, this.data, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyList build();

        public _FinalStage pages(Optional<OffsetPages> var1);

        public _FinalStage pages(OffsetPages var1);

        public _FinalStage data(List<Company> var1);

        public _FinalStage addData(Company var1);

        public _FinalStage addAllData(List<Company> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(CompanyList var1);
    }
}

