/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactArchived {
    private final String id;
    private final Optional<String> externalId;
    private final boolean archived;
    private final Map<String, Object> additionalProperties;

    private ContactArchived(String id, Optional<String> externalId, boolean archived, Map<String, Object> additionalProperties) {
        this.id = id;
        this.externalId = externalId;
        this.archived = archived;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "contact";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="archived")
    public boolean getArchived() {
        return this.archived;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactArchived && this.equalTo((ContactArchived)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactArchived other) {
        return this.id.equals(other.id) && this.externalId.equals(other.externalId) && this.archived == other.archived;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.externalId, this.archived);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ArchivedStage,
    _FinalStage {
        private String id;
        private boolean archived;
        private Optional<String> externalId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContactArchived other) {
            this.id(other.getId());
            this.externalId(other.getExternalId());
            this.archived(other.getArchived());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ArchivedStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="archived")
        public _FinalStage archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public ContactArchived build() {
            return new ContactArchived(this.id, this.externalId, this.archived, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContactArchived build();

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);
    }

    public static interface ArchivedStage {
        public _FinalStage archived(boolean var1);
    }

    public static interface IdStage {
        public ArchivedStage id(@NotNull String var1);

        public Builder from(ContactArchived var1);
    }
}

