/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ConversationAttachmentFiles;
import com.intercom.api.types.IContactReplyBaseRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactReplyEmailRequest
implements IContactReplyBaseRequest {
    private final String body;
    private final Optional<Integer> createdAt;
    private final Optional<List<String>> attachmentUrls;
    private final String email;
    private final Optional<List<ConversationAttachmentFiles>> attachmentFiles;
    private final Map<String, Object> additionalProperties;

    private ContactReplyEmailRequest(String body, Optional<Integer> createdAt, Optional<List<String>> attachmentUrls, String email, Optional<List<ConversationAttachmentFiles>> attachmentFiles, Map<String, Object> additionalProperties) {
        this.body = body;
        this.createdAt = createdAt;
        this.attachmentUrls = attachmentUrls;
        this.email = email;
        this.attachmentFiles = attachmentFiles;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="message_type")
    public String getMessageType() {
        return "comment";
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return "user";
    }

    @Override
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="attachment_urls")
    public Optional<List<String>> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="attachment_files")
    public Optional<List<ConversationAttachmentFiles>> getAttachmentFiles() {
        return this.attachmentFiles;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactReplyEmailRequest && this.equalTo((ContactReplyEmailRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactReplyEmailRequest other) {
        return this.body.equals(other.body) && this.createdAt.equals(other.createdAt) && this.attachmentUrls.equals(other.attachmentUrls) && this.email.equals(other.email) && this.attachmentFiles.equals(other.attachmentFiles);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.createdAt, this.attachmentUrls, this.email, this.attachmentFiles);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BodyStage,
    EmailStage,
    _FinalStage {
        private String body;
        private String email;
        private Optional<List<ConversationAttachmentFiles>> attachmentFiles = Optional.empty();
        private Optional<List<String>> attachmentUrls = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContactReplyEmailRequest other) {
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            this.attachmentUrls(other.getAttachmentUrls());
            this.email(other.getEmail());
            this.attachmentFiles(other.getAttachmentFiles());
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public EmailStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public _FinalStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        public _FinalStage attachmentFiles(List<ConversationAttachmentFiles> attachmentFiles) {
            this.attachmentFiles = Optional.ofNullable(attachmentFiles);
            return this;
        }

        @Override
        @JsonSetter(value="attachment_files", nulls=Nulls.SKIP)
        public _FinalStage attachmentFiles(Optional<List<ConversationAttachmentFiles>> attachmentFiles) {
            this.attachmentFiles = attachmentFiles;
            return this;
        }

        @Override
        public _FinalStage attachmentUrls(List<String> attachmentUrls) {
            this.attachmentUrls = Optional.ofNullable(attachmentUrls);
            return this;
        }

        @Override
        @JsonSetter(value="attachment_urls", nulls=Nulls.SKIP)
        public _FinalStage attachmentUrls(Optional<List<String>> attachmentUrls) {
            this.attachmentUrls = attachmentUrls;
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public ContactReplyEmailRequest build() {
            return new ContactReplyEmailRequest(this.body, this.createdAt, this.attachmentUrls, this.email, this.attachmentFiles, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContactReplyEmailRequest build();

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);

        public _FinalStage attachmentUrls(Optional<List<String>> var1);

        public _FinalStage attachmentUrls(List<String> var1);

        public _FinalStage attachmentFiles(Optional<List<ConversationAttachmentFiles>> var1);

        public _FinalStage attachmentFiles(List<ConversationAttachmentFiles> var1);
    }

    public static interface EmailStage {
        public _FinalStage email(@NotNull String var1);
    }

    public static interface BodyStage {
        public EmailStage body(@NotNull String var1);

        public Builder from(ContactReplyEmailRequest var1);
    }
}

